#ifndef MpsSensor1BunchTrainDatum_HH
#define MpsSensor1BunchTrainDatum_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"


class MpsSensor1BunchTrainDatum {

public:
  MpsSensor1BunchTrainDatum();
  MpsSensor1BunchTrainDatum(unsigned d);

  bool channel(unsigned c) const;
  void channel(unsigned c, bool b);

  unsigned group() const;
  void     group(unsigned g);

  unsigned row() const;
  void     row(unsigned r);

  unsigned timeStamp() const;
  void     timeStamp(unsigned t);

  MpsSensor1Hit sensorHit(unsigned r) const;

  void datum(unsigned d);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  UtlPack _datum;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsSensor1BunchTrainDatum::MpsSensor1BunchTrainDatum() {
}

MpsSensor1BunchTrainDatum::MpsSensor1BunchTrainDatum(unsigned d) : _datum(d) {
}

bool MpsSensor1BunchTrainDatum::channel(unsigned c) const {
  assert(c<6);
  return _datum.bit(c);
}

void MpsSensor1BunchTrainDatum::channel(unsigned c, bool b) {
  assert(c<6);
  _datum.bit(c,b);
}

unsigned MpsSensor1BunchTrainDatum::group() const {
  return _datum.bits(6,8);
}

void MpsSensor1BunchTrainDatum::group(unsigned g) {
  assert(g<7);
  _datum.bits(6,8,g);
}

unsigned MpsSensor1BunchTrainDatum::row() const {
  return _datum.bits(9,17);
}

void MpsSensor1BunchTrainDatum::row(unsigned r) {
  assert(r<168);
  _datum.bits(9,17,r);
}

unsigned MpsSensor1BunchTrainDatum::timeStamp() const {
  return _datum.bits(18,31);
}

void MpsSensor1BunchTrainDatum::timeStamp(unsigned t) {
  assert(t<0x4000);
  _datum.bits(18,31,t);
}

void MpsSensor1BunchTrainDatum::datum(unsigned d) {
  _datum.word(d);
}

std::ostream& MpsSensor1BunchTrainDatum::print(std::ostream &o, std::string s) const {
  o << s << "MpsSensor1BunchTrainDatum::print()" << std::endl;

  o << s << " Datum = " << printHex(_datum.word()) << std::endl;
  o << s << "  Channels = " << printHex((unsigned char)_datum.bits(0,5))
    << std::endl;
  o << s << "  Group = " << group() << std::endl;
  o << s << "  Row = " << row() << std::endl;
  o << s << "  Timestamp = " << timeStamp() << std::endl;

  return o;
}

#endif
#endif
