#ifndef MpsAnalysisThresholdScan_HH
#define MpsAnalysisThresholdScan_HH

#include <cassert>

#include "RcdUserRO.hh"
#include "SubAccessor.hh"

#include "HstCfgScan.hh"
#include "MpsSensor1BunchTrainData.hh"


class MpsAnalysisThresholdScan : public MpsAnalysisBase {

public:
  MpsAnalysisThresholdScan() : MpsAnalysisBase("MpsAnalysisThresholdScan") {
  }

  virtual ~MpsAnalysisThresholdScan() {
    for(unsigned s(0);s<_vLocation.size();s++) {
      for(unsigned i(0);i<4;i++) {
	_regionWords[s][i]->runEnd();
	_regionLogWs[s][i]->runEnd();
      }
    } 
    endRoot();
  }

  virtual bool mpsAnalysisValidRun(IlcRunType::Type t) const {
    return t==IlcRunType::mpsThresholdScan;
  }

  bool runStart(const RcdRecord &r) {
    assert(_vLocation.size()<=4);

    for(unsigned s(0);s<_vLocation.size();s++) {
      for(unsigned i(0);i<4;i++) {
	std::ostringstream sLabel[2];
	sLabel[0] << _sensorLabel[s] << "Region" << i << "Lin";
	sLabel[1] << _sensorLabel[s] << "Region" << i << "Log";
	
	std::ostringstream sTitle[2];
	sTitle[0] << "Region " << i << ", Number of words";
	sTitle[1] << "Region " << i << ", Log10(number of words)";
	
	_regionWords[s][i]=new HstCfgScan(sLabel[0].str().c_str(),
					  sTitle[0].str().c_str(),
					  3200,0.0,3200.0);
	
	_regionLogWs[s][i]=new HstCfgScan(sLabel[1].str().c_str(),
					  sTitle[1].str().c_str(),
					  1000,0.0,4.0);
      }
    }

    for(unsigned s(0);s<_vLocation.size();s++) {
      for(unsigned i(0);i<4;i++) {
	_regionWords[s][i]->runStart(_runStart.runNumber(),_sensorTitle[s]+", Threshold");
	_regionLogWs[s][i]->runStart(_runStart.runNumber(),_sensorTitle[s]+", Threshold");
      }
    }
    return true;
  }

  bool runEnd(const RcdRecord &r) {
    for(unsigned s(0);s<_vLocation.size();s++) {
      for(unsigned i(0);i<4;i++) {
	_regionWords[s][i]->runEnd();
	_regionLogWs[s][i]->runEnd();
      }
    }
    return true;
  }

  bool configurationStart(const RcdRecord &r) {
    for(unsigned s(0);s<_vLocation.size();s++) {
      for(unsigned i(0);i<4;i++) {
	_regionWords[s][i]->configurationStart(_vPcbConfigurationData[s].regionThresholdValue(i));
	_regionLogWs[s][i]->configurationStart(_vPcbConfigurationData[s].regionThresholdValue(i));
      }
    }
    return true;
  }
  
  bool bunchTrain(const RcdRecord &r) {
    SubAccessor accessor(r);

    std::vector<const MpsLocationData<MpsSensor1BunchTrainData>* >
      w(accessor.access< MpsLocationData<MpsSensor1BunchTrainData> >());
    assert(w.size()==_vLocation.size());
    if(doPrint(r.recordType(),1)) w[0]->print(std::cout) << std::endl;

    for(unsigned s(0);s<w.size();s++) {
      for(unsigned i(0);i<4;i++) {
	_regionWords[s][i]->Fill(w[s]->data()->numberOfRegionHits(i));
	if(w[s]->data()->numberOfRegionHits(i)>0) {
	  _regionLogWs[s][i]->Fill(std::log10((double)w[s]->data()->numberOfRegionHits(i)));
	}
      }
    }

    return true;
  }


private:
  HstCfgScan *_regionWords[4][4];
  HstCfgScan *_regionLogWs[4][4];
};

#endif
