void HstAhcEvent(const unsigned bits=0xffffff) {

  // Histogram consumer script. Create a canvas and 3 pads. Connect
  // to memory mapped file "hsimple.map", that was created by hprod.C.
  // It reads the histograms from shared memory and displays them
  // in the pads (sleeping for 0.1 seconds before starting a new read-out
  // cycle). This script runs in an infinite loop, so use ctrl-c to stop it.
  
  gROOT->Reset();
  
  // Open the memory mapped file "hsimple.map" in "READ" (default) mode.
  mfile = TMapFile::Create("HstGeneric.map");
  
  // Print status of mapped file and list its contents
  mfile->Print();
  //mfile->ls();
  
  // Create a new canvas
  TCanvas *hstEmcEventCanvas(0);
  
  // Create pointer to the object in shared memory.
  TH1F *hstCrcEvent(0);
  hstCrcEvent=(TH1F*)mfile->Get("HstCrcEventCrate1");
  
  if(hstCrcEvent!=0) {
    hstEmcEventCanvas=new 
      TCanvas("HstAhcEventCanvas","HstAhcEvent",10,10,910,900/1.414+10);
    gPad->Range(0.0,-0.5,1.5*1.414,1.0);
  } else {
    return;
  }
  
  TLine *lXY[2][19];
  for(unsigned i(0);i<2;i++) {
    for(unsigned j(0);j<19;j++) {
      if(i==0) lXY[i][j]=new TLine(0.1,0.1+0.8*j/18.0,0.9,0.1+0.8*j/18.0);
      else     lXY[i][j]=new TLine(0.1+0.8*j/18.0,0.1,0.1+0.8*j/18.0,0.9);
      lXY[i][j]->SetLineColor(1);
      lXY[i][j]->SetLineWidth(5);
    }
  }
  
  TLine *lXZ[2][19];
  for(unsigned i(0);i<2;i++) {
    for(unsigned j(0);j<19;j++) {
      if(i==0) lXZ[i][j]=new TLine(0.1,-0.5+0.4*j/18.0,0.9,-0.5+0.4*j/18.0);
      else     lXZ[i][j]=new TLine(0.1+0.8*j/18.0,-0.5,0.1+0.8*j/18.0,0.0);
      lXZ[i][j]->SetLineColor(1);
      lXZ[i][j]->SetLineWidth(5);
    }
  }
  
  TLine *lYZ[2][19];
  for(unsigned i(0);i<2;i++) {
    for(unsigned j(0);j<19;j++) {
      if(i==0) lYZ[i][j]=new TLine(1.1,0.1+0.8*j/18.0,1.5,0.1+0.8*j/18.0);
      else     lYZ[i][j]=new TLine(1.1+0.4*j/18.0,0.1,1.1+0.4*j/18.0,0.9);
      lYZ[i][j]->SetLineColor(1);
      lYZ[i][j]->SetLineWidth(5);
    }
  }
  
  TBox *bXY[216];
  unsigned nBox(0);
  for(unsigned i(0);i<30;i++) {
    for(unsigned j(0);j<30;j++) {
      if(i==0 && (j%4)==0 && j>3 && j<24) {
	bXY[nBox]=new TBox(0.1+0.8*i/30.0,0.1+0.8*j/30.0,0.1+0.8*(i+4)/30.0,0.1+0.8*(j+4)/30.0);
	bXY[nBox]->SetFillColor(2);
	nBox++;
      }
      if(i==26 && (j%4)==2 && j>3 && j<26) {
	bXY[nBox]=new TBox(0.1+0.8*i/30.0,0.1+0.8*j/30.0,0.1+0.8*(i+4)/30.0,0.1+0.8*(j+4)/30.0);
	bXY[nBox]->SetFillColor(2);
	nBox++;
      }
      if(j==0 && (i%4)==2 && i>3 && i<26) {
	bXY[nBox]=new TBox(0.1+0.8*i/30.0,0.1+0.8*j/30.0,0.1+0.8*(i+4)/30.0,0.1+0.8*(j+4)/30.0);
	bXY[nBox]->SetFillColor(2);
	nBox++;
      }
      if(j==26 && (i%4)==0 && i>3 & i<24) {
	bXY[nBox]=new TBox(0.1+0.8*i/30.0,0.1+0.8*j/30.0,0.1+0.8*(i+4)/30.0,0.1+0.8*(j+4)/30.0);
	bXY[nBox]->SetFillColor(2);
	nBox++;
      }
    }
  }

  std::cout << "nBox = " << nBox << endl;
  
  for(unsigned i=nBox;i<216;i++) {
    bXY[i]=new TBox(0.0,0.0,0.05,0.05);
    bXY[i]->SetFillColor(3);
  }

  // Loop displaying the histograms. Once the producer stops this
  // script will break out of the loop.
  while (true) {
    hstCrcEvent=(TH1F*)mfile->Get("HstCrcEventCrate1");
    //if(hstCrcEvent!=0) hstCrcEvent->Draw();
    //if(hstCrcEvent->
       
    if(hstCrcEvent!=0) {

      /*
      // Set colours of boxes
      Float_t px,py;
      for(unsigned i(0);i<216;i++) {
	bXY[i]->SetFillColor(0);
	gRandom->Rannor(px,py);
	if(px>0.7) bXY[i]->SetFillColor(2);
      }
      */
      
      for(unsigned i(0);i<26;i++) {
	bXY[i]->Draw("f");
      }

      /*
	for(unsigned i(0);i<2;i++) {
	for(unsigned j(0);j<19;j++) {
	lXY[i][j]->Draw();
	lXZ[i][j]->Draw();
	lYZ[i][j]->Draw();
	}
	}
     */
      //box.Draw("f");
      //box2.Draw("f");
      
      hstEmcEventCanvas->Modified();
      hstEmcEventCanvas->Update();
      
      gSystem->Sleep(1000);   // sleep for 1 seconds
      if (gSystem->ProcessEvents()) break;
    }
  }
}
