#ifndef MpsReadoutConfigurationData_HH
#define MpsReadoutConfigurationData_HH

#include <iostream>
#include <fstream>


class MpsReadoutConfigurationData {

public:
  enum {
    versionNumber=0
  };

  MpsReadoutConfigurationData();

  bool usbDaqEnable(unsigned u) const;
  void usbDaqEnableAll(bool b);
  void usbDaqEnable(unsigned u, bool b);

  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  UtlPack _enables;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsReadoutConfigurationData::MpsReadoutConfigurationData() {
  memset(this,0,sizeof(MpsReadoutConfigurationData));
  _enables=0xffffffff;
}

bool MpsReadoutConfigurationData::usbDaqEnable(unsigned u) const {
  assert(u<4);
  return _enables.bit(u);
}

void MpsReadoutConfigurationData::usbDaqEnableAll(bool b) {
  if(b) _enables.word(0xffffffff);
  else  _enables.word(         0);
}

void MpsReadoutConfigurationData::usbDaqEnable(unsigned u, bool b) {
  assert(u<4);
  _enables.bit(u,b);
}

std::ostream& MpsReadoutConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "MpsReadoutConfigurationData::print()" << std::endl;
  o << s << " Enables = " << printHex(_enables) << std::endl;

  return o;
}

#endif
#endif
