//
// $Id: DhcBeConfigurationData.hh,v 1.5 2008/01/24 22:59:17 jls Exp $
//

#ifndef DhcBeConfigurationData_HH
#define DhcBeConfigurationData_HH

#include <string>
#include <iostream>

#include "UtlPack.hh"


class DhcBeConfigurationData {

public:
  enum {
    versionNumber=0
  };

public:
  DhcBeConfigurationData();

  bool runModeEnable() const;
  void runModeEnable(bool b);

  bool circularModeEnable() const;
  void circularModeEnable(bool b);

  bool standaloneModeEnable() const;
  void standaloneModeEnable(bool b);

  bool timestampSortDisable() const;
  void timestampSortDisable(bool b);

  unsigned short dconEnable() const;
  void           dconEnable(unsigned short n);

  unsigned setOptions() const;
  unsigned resetOptions() const;

  void csr(unsigned n);

  std::ostream& print(std::ostream &o, std::string s="") const;

private:
  UtlPack _csr;
  UtlPack _dcon_enable;
};

DhcBeConfigurationData::DhcBeConfigurationData() {
  _csr=0;
  _dcon_enable=0;
}

bool DhcBeConfigurationData::runModeEnable() const {
  return _csr.bit(0);
}

void DhcBeConfigurationData::runModeEnable(bool b) {
  _csr.bit(0,b);
}

bool DhcBeConfigurationData::circularModeEnable() const {
  return _csr.bit(1);
}

void DhcBeConfigurationData::circularModeEnable(bool b) {
  _csr.bit(1,b);
}

bool DhcBeConfigurationData::standaloneModeEnable() const {
  return _csr.bit(2);
}

void DhcBeConfigurationData::standaloneModeEnable(bool b) {
  _csr.bit(2,b);
}

bool DhcBeConfigurationData::timestampSortDisable() const {
  return _csr.bit(3);
}

void DhcBeConfigurationData::timestampSortDisable(bool b) {
  _csr.bit(3,b);
}

unsigned short DhcBeConfigurationData::dconEnable() const {
  return _dcon_enable.bits(0,11);
}

void DhcBeConfigurationData::dconEnable(unsigned short n) {
  _dcon_enable.bits(0,11,n);
}

unsigned DhcBeConfigurationData::setOptions() const {
  return _csr.halfWord(0);
}

unsigned DhcBeConfigurationData::resetOptions() const {
  return _csr.halfWord(0)<<16;
}

void DhcBeConfigurationData::csr(unsigned n) {
  _csr=n;
}

std::ostream& DhcBeConfigurationData::print(std::ostream &o, std::string s) const {
  o << s << "DhcBeConfigurationData::print()" << std::endl;

  o << s << " CSR            = " << printHex(_csr,0) << std::endl;
  o << s << " DCON_Enable    = " << printHex(_dcon_enable,0) << std::endl;
  return o;
}

#endif // DhcBeConfigurationData_HH
