#ifndef MpsAnalysisBeamThresholdScan_HH
#define MpsAnalysisBeamThresholdScan_HH

#include <cassert>

#include "TFile.h"
#include "TF1.h"
#include "TH1F.h"
#include "TH2F.h"
#include "TProfile.h"

#include "RcdUserRO.hh"
#include "SubAccessor.hh"

#include "MpsAnalysisBase.hh"
#include "MpsSensor1HitLists.hh"


class MpsAnalysisBeamThresholdScan : public MpsAnalysisBase {

public:
  MpsAnalysisBeamThresholdScan() :
    MpsAnalysisBase("MpsAnalysisBeamThresholdScan") {
  }

  virtual ~MpsAnalysisBeamThresholdScan() {
    endRoot();
  }

  virtual bool mpsAnalysisValidRun(IlcRunType::Type t) const {
    return t==IlcRunType::mpsBeam    || t==IlcRunType::mpsBeamThresholdScan ||
           t==IlcRunType::mpsCosmics || t==IlcRunType::mpsCosmicsThresholdScan;
  }

  bool runStart(const RcdRecord &r) {
    _hX[0]=new TH2F("Sensors01X","Sensor 0 vs 1 X",168,0.0,168.0,168,0.0,168.0);
    _hX[1]=new TH2F("Sensors02X","Sensor 0 vs 2 X",168,0.0,168.0,168,0.0,168.0);
    _hX[2]=new TH2F("Sensors03X","Sensor 0 vs 3 X",168,0.0,168.0,168,0.0,168.0);
    _hX[3]=new TH2F("Sensors12X","Sensor 1 vs 2 X",168,0.0,168.0,168,0.0,168.0);
    _hX[4]=new TH2F("Sensors13X","Sensor 1 vs 3 X",168,0.0,168.0,168,0.0,168.0);
    _hX[5]=new TH2F("Sensors23X","Sensor 2 vs 3 X",168,0.0,168.0,168,0.0,168.0);

    _hY[0]=new TH2F("Sensors01Y","Sensor 0 vs 1 Y",168,0.0,168.0,168,0.0,168.0);
    _hY[1]=new TH2F("Sensors02Y","Sensor 0 vs 2 Y",168,0.0,168.0,168,0.0,168.0);
    _hY[2]=new TH2F("Sensors03Y","Sensor 0 vs 3 Y",168,0.0,168.0,168,0.0,168.0);
    _hY[3]=new TH2F("Sensors12Y","Sensor 1 vs 2 Y",168,0.0,168.0,168,0.0,168.0);
    _hY[4]=new TH2F("Sensors13Y","Sensor 1 vs 3 Y",168,0.0,168.0,168,0.0,168.0);
    _hY[5]=new TH2F("Sensors23Y","Sensor 2 vs 3 Y",168,0.0,168.0,168,0.0,168.0);

    _hT[0]=new TH2F("Sensors01T","Sensor 0 vs 1 T",80,0.0,8000.0,80,0.0,8000.0);
    _hT[1]=new TH2F("Sensors02T","Sensor 0 vs 2 T",80,0.0,8000.0,80,0.0,8000.0);
    _hT[2]=new TH2F("Sensors03T","Sensor 0 vs 3 T",80,0.0,8000.0,80,0.0,8000.0);
    _hT[3]=new TH2F("Sensors12T","Sensor 1 vs 2 T",80,0.0,8000.0,80,0.0,8000.0);
    _hT[4]=new TH2F("Sensors13T","Sensor 1 vs 3 T",80,0.0,8000.0,80,0.0,8000.0);
    _hT[5]=new TH2F("Sensors23T","Sensor 2 vs 3 T",80,0.0,8000.0,80,0.0,8000.0);

      std::ostringstream slab;
      slab << "Pmt";

      std::ostringstream stit;
      stit << _runTitle << ", PMT ";

      _PmtHits[0]=new HstCfgScan("Pmt0Hits",
				 "Number of PMT 0 hits",
				 100,0.0,100.0);
      
      _PmtHits[1]=new HstCfgScan("Pmt1Hits",
				 "Number of PMT 1 hits",
				 100,0.0,100.0);

      _PmtHits[2]=new HstCfgScan("PmtCHits",
				 "Number of PMT coincidences",
				 100,0.0,100.0);

      _3Hits=new HstCfgScan((slab.str()+"3Hits").c_str(),
			 (stit.str()+", Number of 3-hits").c_str(),
			    20,0.0,20.0);

      _4Hits=new HstCfgScan((slab.str()+"4Hits").c_str(),
			 (stit.str()+", Number of 4-hits").c_str(),
			    20,0.0,20.0);

      _PmtHits[0]->runStart(_runStart.runNumber());
      _PmtHits[1]->runStart(_runStart.runNumber());
      _PmtHits[2]->runStart(_runStart.runNumber());
      _3Hits->runStart(_runStart.runNumber());
      _4Hits->runStart(_runStart.runNumber());
    return true;
  }

  bool runEnd(const RcdRecord &r) {
    endRoot();
    return true;
  }

  bool configurationStart(const RcdRecord &r) {
    _PmtHits[0]->configurationStart();
    _PmtHits[1]->configurationStart();
    _PmtHits[2]->configurationStart();
    _3Hits->configurationStart();
    _4Hits->configurationStart();

    return true;
  }
  
  bool bunchTrain(const RcdRecord &r) {
    SubAccessor accessor(r);

    std::vector<const MpsLocationData<MpsSensor1BunchTrainData>* >
      w(accessor.access< MpsLocationData<MpsSensor1BunchTrainData> >());
    
    unsigned combo(0);

    _hBnt[0].push_back(new TH1F(_bntLabel.c_str(),_bntTitle.c_str(),8000,0.0,8000.0));

    for(unsigned s0(0);s0<w.size();s0++) {
      if(doPrint(r.recordType(),1)) {
	w[s0]->print(std::cout," ") << std::endl;
      }
      if(!w[s0]->usbDaqMaster()) {

	for(unsigned s1(s0+1);s1<w.size();s1++) {
	  if(!w[s1]->usbDaqMaster()) {

	    for(unsigned region0(0);region0<4;region0++) {
	      const MpsSensor1BunchTrainDatum *p0(w[s0]->data()->regionData(region0));
	      for(unsigned j0(0);j0<w[s0]->data()->numberOfRegionHits(region0);j0++) {
		if(p0[j0].row()<168 && p0[j0].group()<7) {
		  int t0(p0[j0].timeStamp());
		  for(unsigned c0(0);c0<6;c0++) {
		    if(p0[j0].channel(c0)) {
		      int x0(42*region0+6*p0[j0].group()+c0);

		      if(combo==0) _hBnt[0][_hBnt[0].size()-1]->Fill(t0);

		      for(unsigned region1(0);region1<4;region1++) {
			const MpsSensor1BunchTrainDatum *p1(w[s1]->data()->regionData(region1));
			for(unsigned j1(0);j1<w[s1]->data()->numberOfRegionHits(region1);j1++) {
			  if(p1[j1].row()<168 && p1[j1].group()<7) {
			    int t1(p1[j1].timeStamp());
			    for(unsigned c1(0);c1<6;c1++) {
			      if(p1[j1].channel(c1)) {
				int x1(42*region1+6*p1[j1].group()+c1);

				int dx(x0-x1);
				int sx(x0+x1);
				int dy(p0[j0].row()-p1[j1].row());
				int sy(p0[j0].row()+p1[j1].row());
				int dt(t0-t1);

				if(dt>-1 && dt<1) {
				  _hX[combo]->Fill(x0,x1);
				  _hY[combo]->Fill(p0[j0].row(),p1[j1].row());
 				}

				if(((dx>-10 && dx<10) || (sx>158 && sx<178)) &&
				   ((dy>-10 && dy<10) || (sy>158 && sy<178))) {
				  _hT[combo]->Fill(t0,t1);
				}
			      }
			    }
			  }
			}
		      }
		    }
		  }
		}
	      }
	    }
	    combo++;
	  }
	}
      }
    }




    /*
    unsigned n3(0),n4(0);
    for(unsigned t(0);t<8000;t++) {
      unsigned n(0);
      for(unsigned s(0);s<4;s++) {
	if(times[s][t]>0) n++;
      }
      if(n==3) n3++;
      if(n==4) n4++;
    }
    
    _3Hits->Fill(n3);
    _4Hits->Fill(n4);
    */

    unsigned np[3]={0,0,0};
    std::vector<const MpsLocationData<MpsUsbDaqBunchTrainData>* >
      v(accessor.access< MpsLocationData<MpsUsbDaqBunchTrainData> >());

    _hBnt[1].push_back(new TH1F((_bntLabel+"PMT").c_str(),(_bntTitle+", PMTs").c_str(),8000,0.0,8000.0));

    for(unsigned s(0);s<v.size();s++) {
      if(doPrint(r.recordType(),1)) v[s]->print(std::cout) << std::endl;

      const MpsUsbDaqBunchTrainDatum *q(v[s]->data()->data());
      for(unsigned k(0);k<v[s]->data()->numberOfTags();k++) {

	_hBnt[1][_hBnt[1].size()-1]->Fill(q[k].timeStamp(),q[k].channels());

	if(q[k].channel(0)) np[0]++;
	if(q[k].channel(1)) np[1]++;
	if(q[k].channel(0) && q[k].channel(1)) np[2]++;
      }
    }
    _PmtHits[0]->Fill(np[0]);
    _PmtHits[1]->Fill(np[1]);
    _PmtHits[2]->Fill(np[2]);

    return true;
  }

  void endRoot() {
    if(_rootFile!=0) {
      _rootFile->cd();
      _PmtHits[0]->runEnd();
      _PmtHits[1]->runEnd();
      _PmtHits[2]->runEnd();
      _3Hits->runEnd();
      _4Hits->runEnd();

      MpsAnalysisBase::endRoot();
    }
  }


private:
  TH2F *_hX[6];
  TH2F *_hY[6];
  TH2F *_hT[6];

  HstCfgScan *_PmtHits[3];
  HstCfgScan *_3Hits;
  HstCfgScan *_4Hits;

  std::vector<TH1F*> _hBnt[2];
};

#endif
