#ifndef MpsUsbDaqBunchTrainData_HH
#define MpsUsbDaqBunchTrainData_HH

#include <iostream>
#include <fstream>

#include "UtlPack.hh"

#include "MpsUsbDaqBunchTrainDatum.hh"


class MpsUsbDaqBunchTrainData {

public:
  enum {
    versionNumber=0
  };

  MpsUsbDaqBunchTrainData();

  unsigned numberOfTries() const;
  void     numberOfTries(unsigned n);

  unsigned numberOfTags() const;
  void     numberOfTags(unsigned n);

  const MpsUsbDaqBunchTrainDatum* data() const;
        MpsUsbDaqBunchTrainDatum* data();


  std::vector<unsigned> tagVector() const;
  void                  tagVector(const std::vector<unsigned> &v);
 
  std::ostream& print(std::ostream &o=std::cout, std::string s="") const;


private:
  unsigned _numberOfTries;
  unsigned _numberOfTags;
};


#ifdef CALICE_DAQ_ICC

#include <cstring>

#include "UtlPrintHex.hh"


MpsUsbDaqBunchTrainData::MpsUsbDaqBunchTrainData() {
  memset(this,0,sizeof(MpsUsbDaqBunchTrainData));
}

unsigned MpsUsbDaqBunchTrainData::numberOfTries() const {
  return _numberOfTries;
}

void MpsUsbDaqBunchTrainData::numberOfTries(unsigned n) {
  _numberOfTries=n;
}

unsigned MpsUsbDaqBunchTrainData::numberOfTags() const {
  return _numberOfTags;
}

void MpsUsbDaqBunchTrainData::numberOfTags(unsigned n) {
  _numberOfTags=n;
}

const MpsUsbDaqBunchTrainDatum* MpsUsbDaqBunchTrainData::data() const {
  return (const MpsUsbDaqBunchTrainDatum*)(this+1);
}

MpsUsbDaqBunchTrainDatum* MpsUsbDaqBunchTrainData::data() {
  return (MpsUsbDaqBunchTrainDatum*)(this+1);
}

std::vector<unsigned> MpsUsbDaqBunchTrainData::tagVector() const {
  std::vector<unsigned> v;
  const unsigned *p((const unsigned*)(this+1));
  for(unsigned i(0);i<_numberOfTags;i++) {
    v.push_back(p[i]);
  }
  return v;
}
 
void MpsUsbDaqBunchTrainData::tagVector(const std::vector<unsigned> &v) {
  unsigned *p((unsigned*)(this+1));
  for(unsigned i(0);i<v.size();i++) {
    p[i]=v[i];
  }
  _numberOfTags=v.size();
}

std::ostream& MpsUsbDaqBunchTrainData::print(std::ostream &o, std::string s) const {
  o << s << "MpsUsbDaqBunchTrainData::print()" << std::endl;
  o << s << " Number of tries = " << _numberOfTries << std::endl;
  o << s << " Number of tags = " << _numberOfTags << std::endl;

  /*
  const unsigned *p((const unsigned*)(this+1));
  for(unsigned i(0);i<_numberOfTags;i++) {
    o << s << "  Tag " << std::setw(4) << i << " = "
      << printHex(p[i]) << std::endl;
  }
  */

  const MpsUsbDaqBunchTrainDatum *p(data());
  for(unsigned i(0);i<_numberOfTags;i++) {
    p[i].print(o,s+" ");
  }

  return o;
}

#endif
#endif
