//
// $Id: TtmLocation.hh,v 1.2 2007/12/18 18:32:07 jls Exp $
//

#ifndef TtmLocation_HH
#define TtmLocation_HH

#include <string>
#include <iostream>

#include "UtlLocation.hh"
#include "UtlPrintHex.hh"

class TtmLocation : public UtlLocation {

public:
  TtmLocation();
  TtmLocation(unsigned char c, unsigned char s);
  
  bool verify() const;

  std::ostream& print(std::ostream &o, std::string s="") const;

};


TtmLocation::TtmLocation() : UtlLocation() {
}

TtmLocation::TtmLocation(unsigned char c, unsigned char s) :
  UtlLocation(c,s,0) {
}
  
bool TtmLocation::verify() const {
  return slotNumber()<22;
}

std::ostream& TtmLocation::print(std::ostream &o, std::string s) const {
  o << s << "TtmLocation::print()" << std::endl;

  o << s << " Crate number     = "
    << (unsigned)crateNumber();
  o << std::endl;

  o << s << " Slot number      = "
    << (unsigned)slotNumber();
  o << std::endl;

  return o;
}

#endif // TtmLocation_HH 
