#ifndef DaqAnalysis_HH
#define DaqAnalysis_HH

#include <cassert>

#include "RcdUserRO.hh"
#include "SubAccessor.hh"


class DaqAnalysis : public RcdUserRO {

public:

  // Set default bits
  enum {
    defaultDaqAnalysisBits=0xfffffbfd
  };


  DaqAnalysis(const UtlPack bits=defaultDaqAnalysisBits) :
    _ignorRunType(true) {
  }

  virtual ~DaqAnalysis() {
  }

  virtual bool record(const RcdRecord &r) {

    if(r.recordType()==RcdHeader::runStart) {

      // Possibly set print level
      if(!_ignorRunType) {
	SubAccessor accessor(r);
	std::vector<const DaqRunStart*>
	  v(accessor.extract<DaqRunStart>());
        if(v.size()==1) printLevel(v[0]->runType().printLevel());
      }
    }

    return true;
  }

  void ignorRunType(bool b) {
    _ignorRunType=b;
  }

private:
  bool _ignorRunType;
};

#endif
