//
// $Id: DhcEventData.hh,v 1.1 2008/06/27 10:34:05 meyern Exp $
//

#ifndef DhcEventData_HH
#define DhcEventData_HH

#include <iostream>
#include <fstream>
#include <string>

#include "UtlPrintHex.hh"
#include "UtlPack.hh"

#include "DhcFeHitData.hh"


class DhcEventData {

public:
  enum {
    versionNumber=0
  };

  DhcEventData();

  unsigned numberOfWords() const;
  void     numberOfWords(unsigned n);

  const unsigned* data() const;
  unsigned*       data();

  const DhcFeHitData* feData(unsigned f) const;
  DhcFeHitData*       feData(unsigned f);

  bool verify(bool p=false) const;

  std::ostream& print(std::ostream &o, std::string s="", bool raw=false) const;


private:
  unsigned _numberOfWords;
};

DhcEventData::DhcEventData() {
  memset(this,0,sizeof(DhcEventData));
}

unsigned DhcEventData::numberOfWords() const {
  return _numberOfWords;
}

void DhcEventData::numberOfWords(unsigned n) {
  _numberOfWords=n;
}

const unsigned* DhcEventData::data() const {
  return (&_numberOfWords)+1;
}

unsigned* DhcEventData::data() {
  return (&_numberOfWords)+1;
}

const DhcFeHitData* DhcEventData::feData(unsigned f) const {

  unsigned n(4*f);
  if (_numberOfWords<n) return 0;

  return (const DhcFeHitData*)(data()+n);
}

DhcFeHitData* DhcEventData::feData(unsigned f) {

  unsigned n(4*f);
  if (_numberOfWords<n) return 0;

  return (DhcFeHitData*)(data()+n);
}

bool DhcEventData::verify(bool p) const {
  if(_numberOfWords==0) return true;

  for(unsigned i(0);i<_numberOfWords/4; i++) {
    const DhcFeHitData* hits(feData(i));
    if (!hits->verify()) return false;
  }
  return true;
}

std::ostream& DhcEventData::print(std::ostream &o, std::string s, bool raw) const {
  o << s << "DhcEventData::print()  Number of words = " 
    << numberOfWords() << std::endl;
  if(_numberOfWords==0) return o;

  if(raw) {
    const unsigned *d(data());
    for(unsigned i(0);i<_numberOfWords;i++) {
      o << s << " Data word " << std::setw(5) << i << " = " << printHex(d[i]) << std::endl;
    }
    return o;
  }

  if (!verify())
    o << s << " ChkSum error " << std::endl;

  for(unsigned i(0);i<_numberOfWords/4; i++) {
    const DhcFeHitData* hits(feData(i));
    hits->print(o, " ");
  }
  return o;
}

#endif // DhcEventData_HH
