#ifndef BmlSlowRunData_HH
#define BmlSlowRunData_HH

#include <string>
#include <iostream>

#include "UtlPack.hh"


class BmlSlowRunData {

public:
  enum {
    versionNumber=0
  };

  BmlSlowRunData();
  BmlSlowRunData(const AhcSlowRunDataV0 &a);

  bool parse(std::string r);
  
  time_t timeStamp() const;
  void   timeStamp(time_t t);

  unsigned numberOfWords() const;

  std::ostream& print(std::ostream &o, std::string s="") const;


private:
  time_t _timeStamp;
  unsigned _numberOfWords;
  double _word[20];
};


#ifdef CALICE_DAQ_ICC

#include <time.h>
#include <cstring>


BmlSlowRunData::BmlSlowRunData() {
  memset(this,0,sizeof(BmlSlowRunData));
}

bool BmlSlowRunData::parse(std::string r) {
  std::istringstream sin(r);
  sin >> _timeStamp;
  if(!sin) return false;

  sin >> _numberOfWords;
  if(!sin) return false;

  if(_numberOfWords>20) _numberOfWords=20;

  for(unsigned i(0);i<_numberOfWords && sin;i++) {
    sin >> _word[i];
  }

  return sin;
}

time_t BmlSlowRunData::timeStamp() const {
  return _timeStamp;
}

void BmlSlowRunData::timeStamp(time_t t) {
  _timeStamp=t;
}

unsigned BmlSlowRunData::numberOfWords() const {
  return _numberOfWords;
}

std::ostream& BmlSlowRunData::print(std::ostream &o, std::string s) const {
  o << s << "BmlSlowRunData::print()" << std::endl;
  o << s << " Timestamp = " << _timeStamp << " = " << ctime(&_timeStamp);
  o << s << " Number of words = " << _numberOfWords << std::endl;

  for(unsigned i(0);i<_numberOfWords;i++) {
    o << s << " Word " << std::setw(2) << i << " = " << _word[i] << std::endl;
  }

  return o;
}

#endif
#endif
