#ifndef FixAll_HH
#define FixAll_HH

// records/inc/fix
#include "FixDaq.hh"
#include "FixCrc.hh"
#include "FixEmc.hh"
#include "FixAhc.hh"

class RcdRecord;

class FixAll {

public:
  FixAll();
  FixAll(unsigned p);

  bool fix(RcdRecord &r);

private:
  FixDaq _fixDaq;
  FixCrc _fixCrc;
  FixEmc _fixEmc;
  FixAhc _fixAhc;
};


#ifdef CALICE_DAQ_ICC

FixAll::FixAll() : _fixDaq(), _fixCrc(), _fixEmc(), _fixAhc() {
}

FixAll::FixAll(unsigned p) : _fixDaq(p), _fixCrc(p), _fixEmc(p), _fixAhc(p) {
}

bool FixAll::fix(RcdRecord &r) {
  bool reply(true);

  if(!_fixDaq.fix(r)) reply=false;
  if(!_fixCrc.fix(r)) reply=false;
  if(!_fixEmc.fix(r)) reply=false;
  if(!_fixAhc.fix(r)) reply=false;
  
  return reply;
}

#endif
#endif
