#ifndef StageController_HH_
#define StageController_HH_

#include "TypeDefs.hh"

#include "USBDAQHardwareInterface.hh"

namespace CALICEMAPS1
{
  using namespace ::USBDAQ;
  
  
  class StageController
  {
  public:

    enum ADDRESSES{
      ADDR_TRIG=1,
      ADDR_STATUS=ADDR_TRIG,
      ADDR_CONF0,
      ADDR_CONF1,
      ADDR_CONF2,
//       ADDR_CONF3,
//       ADDR_CONF4,
      ADDR_STAT0,
      ADDR_STAT1,
      ADDR_STAT2,
      ADDR_LASTREG
    };
      

    StageController();
    virtual ~StageController();

    u32 Status();
    
    void MoveX(int aDistance);
    void MoveY(int aDistance);
    
    int ReadXPosition();
    int ReadYPosition();

    void SetTimeOut(u32 aTimeout);
    u32 ReadTimeOut();

  private:
    void SetXAxis();
    void SetYAxis();
    
    void SetXAddress(u16 aAddr);
    void SetYAddress(u16 aAddr);

  private:
    void Sleep(unsigned long ams);

    void Setup();  
    void TriggerMove();
    u32 PollBusy();
    

  private:
    StageController(const StageController &);
    StageController & operator=(const StageController &);

  protected:


  private:
    ::USBDAQ::USBDAQHardwareInterface * mInterface;
     
  };
  
}//~namespace CALICEMAPS1

#endif//~StageController_HH_

