#include <iostream>
#include "StageController.hh" 

#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include <time.h>

namespace CALICEMAPS1
{

  StageController::StageController()
  {

    try{
      mInterface=new LinuxLibUsbInterface("",
                                          0xcafe,
                                          0xbabe,
                                          0x0000);

      
      mInterface->SetAddressSpaceSize((ADDR_LASTREG));
      
//       u8 lBufIn[256];
//       u8 lBufOut[256];
//       for(int i=0; i<256; i++){
// 	lBufIn[i]=rand();
//       }

 
//       mInterface->WriteBlock(lBufIn, 256);
//       mInterface->ReadBlock(lBufOut, 256);
      
//       for(int i=0; i<256; i++){
// 	if(lBufIn[i]!=lBufOut[i]){
// 	  std::cout<<"mismatch"<<std::endl;
// 	}
//       }
      
//       mInterface->Write(ADDR_CONF1, 0xcafebabe, 0xffffffff);
//        u32 lTemp=0;
//        // char shart=0;
//        //        std::cin>>shart;
//        mInterface->Read(ADDR_CONF1, lTemp);
//        std::cout<<"Temp = "<<std::hex<<lTemp<<std::endl;
      
      
      this->Setup();

    }catch(USBDAQException & aExc){      
      RETHROW(aExc);
    }
  }

  StageController::~StageController()
  {  
    try{
      delete mInterface;
    }catch(USBDAQException & aExc){
      
      
    }

  }
 
  u32 StageController::Status(){
    u32 lTemp=0;
    try{
      
      mInterface->Read(ADDR_STATUS, lTemp);
      if(lTemp & 0x2){
	std::cout<<"A timeout condition occurred"<<std::endl;
      }
      
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
    return lTemp;
  }




  void StageController::MoveX(int aDistance)
  {
    if(aDistance==0)
      return;
    
    try{
      u32 lTravel=0;
      int lDir=0;
      if(aDistance>0){
	lTravel=aDistance;
	lDir=0;
      }else{
	lTravel=-aDistance;
	lDir=0x100;
      }
      this->SetXAxis();
      mInterface->Write(ADDR_CONF1, lTravel);
      mInterface->Write(ADDR_CONF0, lDir, 0x100);
      
      this->TriggerMove();
      
      int lPos1=ReadXPosition();
      int lCount=0;
      while(lCount<10){
	this->Sleep(10);
	int lPos2=ReadXPosition();
	if(lPos1==lPos2){
	  lCount++;
	}else{
	  lCount=0;
	}
	lPos1=lPos2;
      }      
      

    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    

  }
  
  void StageController::MoveY(int aDistance)
  { 
    if(aDistance==0)
      return;
    
    try{
      u32 lTravel=0;
      int lDir=0;
      if(aDistance>0){
	lTravel=aDistance;
	lDir=0x200;
      }else{
	lTravel=-aDistance;
	lDir=0x300;
      }
      
      mInterface->Write(ADDR_CONF1, lTravel);
      mInterface->Write(ADDR_CONF0, lDir, 0x300);
      
      this->TriggerMove();

      int lPos1=ReadYPosition();
      int lCount=0;
      while(lCount<10){
	this->Sleep(10);
	int lPos2=ReadYPosition();
	if(lPos1==lPos2){
	  lCount++;
	}else{
	  lCount=0;
	}
	lPos1=lPos2;
      }      
      

      

    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    

  }
  
  int StageController::ReadXPosition()
  {
    u32 lTemp=0;
    try{
      mInterface->Read(ADDR_STAT0, lTemp);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
    return static_cast<i32>(lTemp);
  }


  int StageController::ReadYPosition()
  {    
    u32 lTemp=0;
    try{
      mInterface->Read(ADDR_STAT1, lTemp);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
    return static_cast<i32>(lTemp);
  }


  void StageController::Setup()
  {
    try{
      // must: set x and y address
      u32 lAddr=0xe | 0xb0;
      mInterface->Write(ADDR_CONF0, lAddr, 0xff);
      
      //mInterface->Read(ADDR_CONF0, lAddr);
      //std::cout<<"Addresses set to "<<std::hex<<(lAddr & 0xff)<<std::endl;

      // 25 ns bit period, rate is 1 Hz minimum.
      //    => set nominal to 60000000 ~ 1.5s
      this->SetTimeOut(40000000);
      
      

    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
  }

  void StageController::TriggerMove()
  {
    try{
      mInterface->Write(ADDR_TRIG, 0x1, 5);
      
      this->PollBusy();
      
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
  }

  void StageController::SetTimeOut(u32 aTimeout){
    try{
      mInterface->Write(ADDR_CONF2, aTimeout);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
  }

  

  u32 StageController::ReadTimeOut(){
    u32 lTemp=0;
    try{
      mInterface->Read(ADDR_CONF2,lTemp);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
    return lTemp;
  }

  u32 StageController::PollBusy()
  {
    u32 lTemp=0;
    try{
      do{
	mInterface->Read(ADDR_STATUS,lTemp);
      }while(lTemp&0x1);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
    return lTemp;
  }

  void StageController::SetXAxis()
  {
    try{
      u32 lTemp=0x200;
      mInterface->Write(ADDR_CONF0,0,lTemp);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
    
  }
  

  void StageController::SetYAxis()
  {
    try{
      u32 lTemp=0x200;
      mInterface->Write(ADDR_CONF0,lTemp,lTemp);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
  }
  
  void StageController::SetXAddress(u16 aAddr){
    try{
      u32 lTemp=0xf & aAddr;
      mInterface->Write(ADDR_CONF0,lTemp,0xf);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    
  }

  void StageController::SetYAddress(u16 aAddr){
    try{
      u32 lTemp=0xf0 & (aAddr<<4);
      mInterface->Write(ADDR_CONF0,lTemp,0xf0);
    }catch(USBDAQException & aExc){
      RETHROW(aExc);
    }    

  }
  
  void StageController::Sleep(unsigned long ams)
  {
    struct timespec lReq;
    struct timespec lRem;
    lReq.tv_sec=ams/1000;
    lReq.tv_nsec=(ams%1000)*1000000;
    nanosleep(&lReq, &lRem);
  }

  
}//~namespace CALICEMAPS1


