MAKE=make

CXX=g++


EXE_EXT=
#PLATFORM=Linux

INCDIR= \
-Iinclude \
-Iinterface\

#CXXFLAGS= -Wall -ansi -pedantic -g -D$(PLATFORM) -pthread -D_REENTRANT -c
CXXFLAGS= -c -Wall -fPIC -std=c++98 -g -D$(PLATFORM) 

ifeq ($(PLATFORM),Linux)
CXXFLAGS+= -pthread -D_REENTRANT 
endif

DEPFLAGS= -MM -D$(PLATFORM)

PROJECTDIR=$(CALICEMAPS1_SW_DIR)


SRCDIR=src
OBJDIR=obj
LIBDIR=lib

PLATFORM_SRCDIR=$(SRCDIR)/$(PLATFORM)
COMMON_SRCDIR=$(SRCDIR)/Common

PLAT_SRC=$(wildcard $(PLATFORM_SRCDIR)/*.cc)
PLAT_OBJ=$(subst $(PLATFORM_SRCDIR), $(OBJDIR),$(PLAT_SRC:.cc=.o))

COMM_SRC=$(wildcard $(COMMON_SRCDIR)/*.cc)
COMM_OBJ=$(subst $(COMMON_SRCDIR), $(OBJDIR),$(COMM_SRC:.cc=.o))

DEP_FILES=$(subst $(COMMON_SRCDIR),$(OBJDIR), $(COMM_SRC:.cc=.d))
DEP_FILES+=$(subst $(PLATFORM_SRCDIR),$(OBJDIR), $(PLAT_SRC:.cc=.d))

# link variables: 

ifeq ($(PLATFORM),Linux)
LD=g++ 
else
LD=c:/Dev-Cpp/bin/mingw32-g++.exe
endif

ifeq ($(PLATFORM),Linux)
LIB_EXT=so
else
LIB_EXT=dll
endif

LINK_SEARCH= 

LIBTARGET=lib$(MODULE).$(LIB_EXT)

ifeq ($(PLATFORM),Linux)
LIBS= -lpthread 
else
LIBS+=-lmingw32
endif

ifeq ($(PLATFORM),Linux)
LDFLAGS= -shared -o
else
LDFLAGS= -shared -export-all-symbols -enable-runtime-pseudo-relocs  -o
endif


# 
# main target : library  
#
$(LIBDIR)/$(LIBTARGET):  $(PLAT_OBJ) $(COMM_OBJ) 


# dependencies

#$(OBJDIR)/%.d: $(COMMON_SRCDIR)/%.cc
#	@echo =============================================================
#	@echo $*
#	@echo $<
#	@echo $@.$$$$
#	@echo $+
#	@echo $%
#	@echo =============================================================
#	$(CXX) $(DEPFLAGS) $(INCDIR) $< > $@.temp 
#	sed 's,\($*\).o[ :]*,$(OBJDIR)/\1.o $@ : ,g' < $@.temp > $@
#	rm -f $@.temp
#	@echo =============================================================




#$(OBJDIR)/%.d: $(PLATFORM_SRCDIR)/%.cc
#	@echo =============================================================
#	$(CXX) $(DEPFLAGS) $(INCDIR) $< -o $@
#	@echo =============================================================

#include $(DEP_FILES)

# build rules: 


$(OBJDIR)/%.o:$(COMMON_SRCDIR)/%.cc 
	@echo =============================================================
	$(CXX) $(CXXFLAGS) $(INCDIR) $< -o $@

$(OBJDIR)/%.o:$(PLATFORM_SRCDIR)/%.cc 
	@echo =============================================================
	$(CXX) $(CXXFLAGS) $(INCDIR) $< -o $@

$(LIBDIR)/$(LIBTARGET) : $(COMM_OBJ) $(PLAT_OBJ)
	@echo =============================================================
	$(LD) $(LDFLAGS) $(LIBDIR)/$(LIBTARGET) $(COMM_OBJ) $(PLAT_OBJ) $(LINK_SEARCH) $(LIBS)
	chcon -t texrel_shlib_t $(PROJECTDIR)/lib/$(LIBTARGET)  

# other things: 

vars:
	@echo "------------------------------------"	
	@echo "PROJECTDIR= " $(PROJECTDIR)
	@echo "Comm. Source dir: " $(COMMON_SRCDIR)
	@echo "Plat. Source dir: " $(PLATFORM_SRCDIR)
	@echo "Comm. Object files: " $(COMM_OBJ)
	@echo "Plat. Object files: " $(PLAT_OBJ)
	@echo "Library:      " $(LIBDIR)/$(LIBTARGET)
	@echo "------------------------------------"
	@echo "platform src files: " $(PLAT_SRC)
	@echo "                ->: " $(PLAT_OBJ)
	@echo "common src files  : " $(COMM_SRC)
	@echo "                ->: " $(COMM_OBJ)
	@echo "------------------------------------"
	@echo "Dependencies : " $(DEP_FILES)
	@echo "------------------------------------"
	@echo "includes: " $(INCDIR)
	@echo "------------------------------------"
	@echo "------------------------------------"
	@echo "Module: " $(MODULE)
	@echo "------------------------------------"


clean:
	rm -f $(DEP_FILES) $(COMM_OBJ) $(PLAT_OBJ) $(LIBDIR)/$(LIBTARGET) 
	rm -f $(OBJDIR)/*.o $(LIBDIR)/*.dll $(LIBDIR)/*.a
	find . -name "*.o" -exec rm \{\} \;
#	rm -f Tools/exe/*
#	rm -f Tests/exe/*

force:
	@$(MAKE) clean
	@$(MAKE)
	@$(MAKE) -C Tests


Tests:
	@$(MAKE) -C Tests

