#!/bin/bash

REF_START=1000
REF_END=2000
STEP_SIZE=200

REFERENCE=18

if [ $# = "4" ] ; then 
    REF_START=$1
    REF_END=$2
    STEP_SIZE=$3
    REFERENCE=$4
    echo "Set Values to " $REF_START $REF_END $STEP_SIZE $REFERENCE
#    exit 0
fi

#exit 0

SENSE_DELAY=30
RD_EN_BCAST=0

# hex col order vector
RO_COL_ORDER=1e

# hex mode: 
SPILLMODE=420

for ((j=$REF_START; j<$REF_END; j+=$STEP_SIZE)) ; do 

    echo "Reference Level = " $j

    ./RefSet $REFERENCE $j
    echo "Triggering Spill..."
    ./SpillTest $SPILLMODE $SENSE_DELAY $RD_EN_BCAST $RO_COL_ORDER


done
