#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>

#include <cstring>

#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  try{
    

    CaliceMaps1TestSystemInterface lInt;

    //lInt.EnableLVDSBuffers();
    
    u16 lRef=0;
    if(argc==2){
      istringstream(argv[1])>>lRef;
    }

    u32 lCount=0;

    u8 lBuf[21];
    
    srand(time(0));
    
    for(u16 i=0; i<21; i++){
      
      lBuf[i]=(rand()&0xff);//i;//0xaa;
      

      cout<<"Loading byte "<<dec<<i<<" : "<<hex<<static_cast<u16>(lBuf[i])<<endl;
    }
    
    u8 lRBBuf[21];
    memset(lRBBuf, 0, 21);
    
    do{
      //cout<<"-------------------------\n";
      for(u16 i=0; i<21; i++)
	lBuf[i]=(rand()&0xff);//i;//0xaa;

      lInt.LoadBottomRow(lBuf);
      lInt.ReadBackBottomRow(lRBBuf, 21, true);
      
      for(u16 i=0; i<21; i++){
	if(lBuf[i]!=lRBBuf[i]){
	  cout<<dec<<lCount<<", "<<i<<" : "
	      <<hex<<static_cast<u16>(lBuf[i])
	      <<" != "
	      <<hex<<static_cast<u16>(lRBBuf[i])
	      <<endl;
	}
      }
      if(gEnd==1){
	break;
      }
      
      if((++lCount)%1000==0){
	cout<<dec<<lCount<<endl;
      }
      
    }while(argc==2);
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
