#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include <time.h>

#include <signal.h>


void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}


int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  
  try{
    
    LinuxLibUsbInterface lInt("", 
			      0xbd7, 
			      0x1003, 
			      0x0000);

    lInt.SetAddressSpaceSize(4);
    
    // for the cable test we need to 
    // write to registers 1 and 2
    // and then read from them: 
    
    //   u32 lReg1In=0xfffe0000;
    // u32 lReg1Out=0;
    
    u32 lCount=0;

    



    // pseudorandom: 


    do{
      u32 lReg1In=rand();
      u32 lReg1Out=0;
      
      u32 lReg2In=rand();
      u32 lReg2Out=0;
      
      
      
      //cout<<"writing first: "<<endl;
      lInt.Write(1, lReg1In);
      // cout<<"writing second: "<<endl;
      lInt.Write(2, lReg2In);
      
      //cout<<"reading first: "<<endl;
      lInt.Read(1, lReg1Out);
      // cout<<hex<<"Reg 1 Output = "<<lReg1Out<<endl;
      
      //cout<<"reading second: "<<endl;
      lInt.Read(2, lReg2Out);
      // cout<<hex<<"Reg 2 Output = "<<lReg2Out<<endl;
      
      if(lReg1In!=lReg1Out || lReg2In!=lReg2Out){	
	cout<<lCount<<endl;
	cout<<hex<<"Reg 1 Input  = "<<lReg1In<<endl;
	cout<<hex<<"Reg 1 Output = "<<lReg1Out<<endl;
	cout<<hex<<"Reg 2 Input  = "<<lReg2In<<endl;
	cout<<hex<<"Reg 2 Output = "<<lReg2Out<<endl;
	break;
      }
    
      
      
      lCount++;
      if((lCount%1000)==0)
	cout<<lCount<<endl;
      
    }while(gEnd==0);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
