#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  
  try{
    
    LinuxLibUsbInterface lInt("", 
			      0xbd7, 
			      0x1003, 
			      0x0000);

    
    u32 lCount=10;
    
    // enable the 
    lInt.Write(2, 0x8000);
    lInt.Write(2, 0x90028000);
    
    do{

      u32 lTemp=0;
      
      
      lTemp=((lCount&0xff)<<20)|(1<<15);
      
      cout<<"Data = "<<hex<<lTemp<<endl;
      lInt.Write(2, lTemp);
      
      lTemp|=0x80000000;
      
      // 
      lInt.Write(2, lTemp);
      
      lCount++;
      cout<<lCount<<endl;

      
    }while(false);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
