#include <signal.h>
#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}




int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  signal(SIGINT, CtrlC);

  try{
    

    CaliceMaps1TestSystemInterface lInt;
    
    do{
      u16 lDAQAddr=lInt.ReadDAQAddress();
    
      cout<<"Address set to : "<<dec<<lDAQAddr<<" (dec)"<<endl;
      cout<<"               : "<<hex<<lDAQAddr<<" (hex)"<<endl;

      if(gEnd){
	break;
      }
    }while(argc>1);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
