#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>

void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}

#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);
  
  u16 lHitEn=0;
  if(argc==2){
    istringstream(argv[1])>>lHitEn;

  }
  cout<<"usage: "<<argv[0]<<" <enable> <sq wave half period>"<<endl;

  u16 lLen=10;


  if(argc==3){
    istringstream(argv[1])>>lHitEn;
    istringstream(argv[2])>>lLen;
  }
  
  cout<<"Setting length to "<<lLen<<" = "<<(2*lLen*25)<<"ns"<<endl;
  
  try{
    

    CaliceMaps1TestSystemInterface lInt;
    lInt.EnableLVDSBuffers();

    lInt.SetDebugHitInEnable(static_cast<bool>(lHitEn), lLen);
    cout<<"Htitin state = "<<lInt.ReadDebugHitInEnable()<<endl;
    
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
