#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include "CaliceMaps1TestSystemInterface.hh"
#include <signal.h>

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  signal(SIGINT, CtrlC);
  
  cout<<"Usage: "<<argv[0]<<" <enable flags for debug rst holds>"<<endl;
  cout<<"bit 0 = rst 200\nbit 1 = rst 600\nbit 2 = diode rst 34\nbit 3 = diode rst 12\nbit 4 = sample rst 34\nbit 5 = shaper rst 34 \n\n"<<endl;
  
  u16 lEn=0;
  if(argc==2){
    istringstream(argv[1])>>hex>>lEn;
  }else{
    
    return 0;
  }
  
  
  try{
    

    CaliceMaps1TestSystemInterface lInt;
     
    lInt.EnableLVDSBuffers();
    
    if(argc==1){
      lInt.SetDebugReset600Duration(48);
      lInt.SetDebugReset200Duration(16);
      lInt.SetDebugDiodeResetDuration(8);
      
      //lInt.SetDebugTrim(0);
      u32 lCount=0;
      do{
		
	lInt.TriggerDebugReset();
	
	cout<<lCount++<<endl;
      }while(gEnd==0);
      
    }else{
  
      cout<<hex<<"mask value = 0x"<<lEn<<endl;
    
      lInt.SetDebugReset200Hold(  (0x01&lEn)>0);
      lInt.SetDebugReset600Hold(  (0x02&lEn)>0);
      lInt.SetDebugDiodeResetHold((0x04&lEn)>0);
      lInt.SetDiodeReset12Hold(   (0x08&lEn)>0);
      lInt.SetSampleReset34Hold(  (0x10&lEn)>0);
      lInt.SetShaperReset34Hold(  (0x20&lEn)>0);
    
      
    }

    cout<<dec<<"rst 200 hold state = "<<lInt.ReadDebugReset200Hold()<<endl;
    cout<<"rst 600 hold state = "<<lInt.ReadDebugReset600Hold()<<endl;
    cout<<"diode rst 34 hold state = "<<lInt.ReadDebugDiodeResetHold()<<endl;
    cout<<"diode rst 12 hold state = "<<lInt.ReadDiodeReset12Hold()<<endl;
    cout<<"sample rst 34 hold state = "<<lInt.ReadSampleReset34Hold()<<endl;
    cout<<"shaper rst 34 hold state = "<<lInt.ReadShaperReset34Hold()<<endl;
    
   //  lInt.SetDebugTrim(lEn);
//     cout<<"Debug Trim = "<<lInt.ReadDebugTrim()<<endl;


  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
