#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include "CaliceMaps1TestSystemInterface.hh"
#include <signal.h>

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  signal(SIGINT, CtrlC);

  u16 lTrim=0;
  if(argc==2){
    istringstream(argv[1])>>lTrim;

  }else{
    cout<<"Usage : "<<argv[0]<<" <trim setting>"<<endl;
    return 0;
  }

  try{
    

    CaliceMaps1TestSystemInterface lInt;
     
    lInt.EnableLVDSBuffers();
    
    //lInt.SetDebugReset600Duration(200);
    //lInt.SetDebugReset200Duration(200);

    
    if(argc==2){
      cout<<"Setting level to "<<lTrim<<endl;
      lInt.SetDebugTrim(lTrim);
    }
    
    cout<<"Debug Trim  = "<<lInt.ReadDebugTrim()<<endl;
      


  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
