#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  
  try{
    
    LinuxLibUsbInterface lInt("", 
			      0xbd7, 
			      0x1003, 
			      0x0000);

    
    u32 lCount=0;
    do{
      u32 lTemp=0;

      lInt.Read(3, lTemp);
      
      cout<<(lCount++)<<" Hex Switch = "<<(lTemp&0xf)<<"  Rx inputs = "<<((lTemp>>4)&0xff)
	  <<"  Laser inputs: "<<((lTemp>>12)&0xff)<<endl;
      
      if(lCount==256)
	break;

    }while(1);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
