#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include "CaliceMaps1TestSystemInterface.hh"


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  try{
    
    CaliceMaps1TestSystemInterface lInt;
    
    lInt.EnableLVDSBuffers();
    // u32 lCount=0;
    do{
      //u32 lTemp=0;

      u16 lId=lInt.ReadSensorId();
      
      cout<<"Sensor ID = "<<lId<<std::endl;

    }while(argc>1);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
