#include <time.h>

#include <iostream>
#include <fstream>

#include "OptionHandler.hh"

#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>

#include "CaliceMaps1TestSystemInterface.hh"
#include "BunchTrainBuffer.hh"


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  int lExpected=4;
  
  if(argc==2){
    istringstream(argv[1])>>lExpected;
    
  }
  
  cout<<"Preempted DAQ count = "<<lExpected<<endl;
  

  try{
    
    CaliceMaps1TestSystemInterface ** lSys;
    lSys=new CaliceMaps1TestSystemInterface * [lExpected];

    int lCount=CaliceMaps1TestSystemInterface::Instance(lSys);
    
    cout<<"============================================"<<endl;
    if(lCount==1){
      cout<<"there was "<<lCount<<" DAQ system detected"<<endl;
    }else{
      cout<<"there were "<<lCount<<" DAQ systems detected"<<endl;
    }
    cout<<"============================================"<<endl;
    
    if(lCount==0)
      return 0;

    for(int i=0; i<lCount; i++){
      if(lSys[i]->IsMaster()){
	cout<<"number "<<i<<" is the master."<<endl;
      }else{
	cout<<"number "<<i<<" is a slave."<<endl;
      }

      if(argc==2){
	lSys[i]->LogicReset();
      }

    }
    
    
    for(int j=0; j<1; j++){
      cout<<"\n\nConectivity: "<<endl;
      for(int i=0; i<lCount; i++){
	cout<<"daq "<<i<<" has address "<<lSys[i]->ReadDAQAddress()
	    <<" and is connected to sensor "<<lSys[i]->ReadSensorId()<<std::endl;
      }
    }

    for(int i=0; i<lCount; i++){
      delete lSys[i];
    }
    delete [] lSys;

  }catch(USBDAQException & aExc){
    cout<<aExc<<endl;
  }
}
