#include <iostream>
#include <sstream>

#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include <signal.h>


int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  
  signal(SIGINT, CtrlC);

  try{
    
    
    LinuxLibUsbInterface lInt("", 
			      0xbd7, 
			      0x1003, 
			      0x0000);

    int lNoCycles=1;
    if(argc==2){
      istringstream(argv[1])>>lNoCycles;
    }
    
    cout<<"set the hex switch to 0 and then press enter to start."<<endl;
    cout<<"When running, turn the switch clockwise. The loop will exit when 15 is reached."<<endl;
    char lStrBuf[256];
    cin.getline(lStrBuf, 256);
    
    
    u32 lTemp=0;
    i32 lIndex=0;
    i32 lLastIndex=0;
    int lLen=0;
    char lScrBuf[256];
    
    int lDacAddresses[16]={0};
    

    do{
      lLastIndex=lIndex;
      lInt.Read(3, lTemp);
      lIndex=lTemp&0xf;
      
      
      
      for(int i=0; i<lLen;i++){
	lScrBuf[i]='\b';
      }
      lScrBuf[lLen+1]='\0';
      cout<<lScrBuf;
      snprintf(lScrBuf, 255, "dac address value = %2d",
       	       static_cast<int>(lIndex));
      
      cout<<lScrBuf;
      cout<<flush;
      lLen=strlen(lScrBuf);

      if(gEnd){
	break;
      }
      if(lDacAddresses[15]>500){
	break;
      }

      lDacAddresses[lIndex]++;
      

    }while(1);
    
    cout<<endl;
    if(gEnd){
      return 0;
    }

    for(int i=0; i<16; i++){
      cout<<"DAC Address = "<<i<<" occurred "<<lDacAddresses[i]<<" times"<<endl;
    }
    cout<<endl;
    //return 0;
    // reset the counter: 
    lInt.Write(2, 1<<14, 1<<14);
    lInt.Write(2, 0, 1<<14);

    cout<<"\nTesting looped back peripheral interfaces: \n"<<endl;

    int lError=0;
    lLen=0;
    for(int i=0; i<lNoCycles; i++){
      u32 lCount=0;
      do{

	
	lInt.Read(3, lTemp);
	u32 lLaserIp=((lTemp>>4)&0xffff);
	//lLaserIp|=(lTemp&)<<12;
	// cout<<dec<<"Counter = "<<(lCount)<<" inputs = "
// 	    <<lLaserIp<<" "<<(lLaserIp==lCount?"  ":"* ")
// 	    <<endl;      
	
	for(int i=0; i<lLen;i++){
	  lScrBuf[i]='\b';
	}
	lScrBuf[lLen+1]='\0';
	cout<<lScrBuf;
	snprintf(lScrBuf, 255, "count = %5d and counter readback = %5d",
		 static_cast<int>(lCount),static_cast<int>(lLaserIp));
	
	cout<<lScrBuf;
	cout<<flush;
	lLen=strlen(lScrBuf);
	
	if(lCount!=lLaserIp){
	  lError++;
	}

	lCount++;
	if(lCount==65536)
	  break;
	
      }while(gEnd==0);
      if(gEnd){
	break; 
      }
    }
    
    cout<<endl;

    cout<<"There were "<<lError<<" errors in the first part of the loopback. "<<endl;
    
    cout<<"Testing sensor interface cable loopback: ctrl-c to end."<<endl;
    
    // now test the cable;
    
    u32 lCount2=0;
    lLen=0;
    do{
      u32 lReg1In=rand();
      u32 lReg1Out=0;

      u32 lReg2In=rand();
      u32 lReg2Out=0;



      //cout<<"writing first: "<<endl;
      lInt.Write(1, lReg1In);
      // cout<<"writing second: "<<endl;
      lInt.Write(2, lReg2In);

      //cout<<"reading first: "<<endl;
      lInt.Read(1, lReg1Out);
      // cout<<hex<<"Reg 1 Output = "<<lReg1Out<<endl;

      //cout<<"reading second: "<<endl;
      lInt.Read(2, lReg2Out);
      // cout<<hex<<"Reg 2 Output = "<<lReg2Out<<endl;

      if(lReg1In!=lReg1Out || lReg2In!=lReg2Out){
        cout<<lCount2<<endl;
        cout<<hex<<"Reg 1 Input  = "<<lReg1In<<endl;
        cout<<hex<<"Reg 1 Output = "<<lReg1Out<<endl;
        cout<<hex<<"Reg 2 Input  = "<<lReg2In<<endl;
        cout<<hex<<"Reg 2 Output = "<<lReg2Out<<endl;
        break;
      }


      
      lCount2++;
      
      for(int i=0; i<lLen;i++){
	lScrBuf[i]='\b';
      }
      lScrBuf[lLen+1]='\0';
      cout<<lScrBuf;
      snprintf(lScrBuf, 255, "count = %7d",
	       static_cast<int>(lCount2));
      
      cout<<lScrBuf;
      cout<<flush;
      lLen=strlen(lScrBuf);
      
    }while(gEnd==0);

    cout<<endl;
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
