#include <iostream>
#include <sstream>

#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  
  try{
    
    LinuxLibUsbInterface lInt("", 
			      0xbd7, 
			      0x1003, 
			      0x0000);

    int lNoCycles=1;
    if(argc==2){
      istringstream(argv[1])>>lNoCycles;
    }
    
    for(int i=0; i<lNoCycles; i++){
      
      u32 lCount=0;
      do{
	u32 lTemp=0;
	
	lInt.Read(3, lTemp);
	u32 lLaserIp=((lTemp>>12)&0xff);
	cout<<"Counter = "<<(lCount)<<" Laser inputs = "<<lLaserIp<<" "<<(lLaserIp==lCount?"  ":"* ")
	    <<endl;      
	
	lCount++;
	if(lCount==256)
	  break;
	
      }while(1);
    }
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
