#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>

void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}

#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);
  
//   u16 lFunc=0;
//   u16 lEn=0;

  
 //  if(argc!=3){
//     cout<<"usage : "<<argv[0]
// 	<<" <monopor=0, sense_enb=1, en12=2, en34=3, buffers=4>  <en=1, dis=0>"
// 	<<endl;
//   }else{
//     istringstream(argv[1])>>lFunc;
//     istringstream(argv[2])>>lEn;
//   }
  
  try{
    
    
    CaliceMaps1TestSystemInterface lInt;
    
    do{
      lInt.SetMonoPOR(true);
      lInt.SetMonoPOR(false);
    }while(gEnd==0);

    
    //}else{
    cout<<"Current state: "<<endl;
    cout<<"monopor   = "<<lInt.ReadMonoPOR()<<endl;
    cout<<"sense enb = "<<lInt.ReadSenseEnable()<<endl;
    cout<<"enable12  = "<<lInt.ReadPixelEnable12()<<endl;
    cout<<"enable34  = "<<lInt.ReadPixelEnable34()<<endl;
      
      //}

   // accessors to the monopole power on reset
 //    void SetMonoPOR(bool aPOR);
//     bool ReadMonoPOR();
        
//     void SetPixelEnable12(bool aEb12);
//     bool ReadPixelEnable12();
 
//     void SetPixelEnable34(bool aEb12);
//     bool ReadPixelEnable34();

//     void SetSenseEnable(bool aSenseEn);
//     bool ReadSenseEnable();
    





    // Sleep(10);
    
    //Sleep(100);
        
    
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
