#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}


int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  try{
    

    CaliceMaps1TestSystemInterface lInt;

    lInt.EnableLVDSBuffers();
    
    u16 lRef=0;
    if(argc==2){
      istringstream(argv[1])>>lRef;
    }

    u32 lCount=0;
    do{
      
      for(u16 lOut=0;lOut<0x100; lOut+=10){
	lInt.SetReferenceLevel(0, lOut);

	for(u16 lBias=0;lBias<0x100; lBias+=1){
	  Sleep(30);
	
	  lInt.SetReferenceLevel(1,lBias);
	  lInt.SetReferenceLevel(2,lBias);
	 
	  cout<<lOut<<"  bias :  "<<lBias<<std::endl;
	  if(gEnd==1){
	    cout<<"stop? "<<endl;
	    cin>>gEnd;
	    
	  }
	  if(gEnd==1){
	    break;
	    
	  }
	
	}
	
// 	if(gEnd==1){
// 	  cin>>gEnd;
// 	} 
	if(gEnd==1){
	  break;
	}
      }
	
      lCount++;
  
  //     if(gEnd==1){
// 	lRef++;
// 	//gEnd=0;
//       }
      if(gEnd==1){
	break;
      }
  }while(argc==2);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
