#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include "CaliceMaps1TestSystemInterface.hh"
#include <signal.h>

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  signal(SIGINT, CtrlC);
  
//   u16 lEn=0;
//   if(argc==2){
//     istringstream(argv[1])>>lEn;
//   }

  cout<<"Usage: "<<argv[0]<<" <rst 600 length> <rst 200 len> <diode rst len> <ref dac high> <ref dac low>"<<endl;
   //   cout<<"bit 0 = rst 200\nbit 1 = rst 600\nbit 2 = diode rst \n\n"<<endl;
  
  if(argc!=6){
    return 1;
  }

  u16 lrst600=0;
  u16 lrst200=0;
  u16 lrstdiode=0;
  u16 lrefh=0;
  u16 lrefl=0;
  
  istringstream(argv[1])>>lrst600;
  istringstream(argv[2])>>lrst200;
  istringstream(argv[3])>>lrstdiode;
  istringstream(argv[4])>>lrefh;
  istringstream(argv[5])>>lrefl;


  try{
    

    CaliceMaps1TestSystemInterface lInt;
     
    lInt.EnableLVDSBuffers();
    
    
    lInt.SetDebugReset600Duration(lrst600);
    lInt.SetDebugReset200Duration(lrst200);
    lInt.SetDebugDiodeResetDuration(lrstdiode);
    
    lInt.SetDebugReset200Hold(false);
    lInt.SetDebugReset600Hold(false);
    lInt.SetDebugDiodeResetHold(false);


    cout<<"reset 600 len = "<<(2*25*lrst600)<<" ns"<<endl;
    cout<<"reset 200 len = "<<(2*25*lrst200)<<" ns"<<endl;
    cout<<"reset diode len = "<<(2*25*lrstdiode)<<" ns"<<endl;
    cout<<"high = "<<lrefh<<endl;
    cout<<"low  = "<<lrefl<<endl;
    cout<<"ref high level = "<<lrefh<<" dac counts"<<endl;
    cout<<"ref low level = "<<lrefl<<" dac counts"<<endl;
    
    
    //lInt.SetDebugTrim(0);
    u32 lCount=0;

    lInt.SetVRst(lrefh);

    do{
      lCount++;
      //if(lCount&0x2)
	//lInt.SetDebugDiodeResetHold(lCount&0x4);
    
      
      lInt.TriggerDebugReset();
      
      u16 lDacLevel=lrefh;
      if(lCount&0x1){
	lDacLevel=lrefl;
      }
      
      
      lInt.SetVRst(lrefl);
      lInt.SetVRst(lrefh);
      //cout<<lInt.ReadVRst()<<endl;
    
    }while(gEnd==0);
    

//     cout<<"rst 200 hold state = "<<lInt.ReadDebugReset200Hold()<<endl;
//     cout<<"rst 600 hold state = "<<lInt.ReadDebugReset600Hold()<<endl;

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
