#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;

  signal(SIGINT, CtrlC);

  
  try{
    
    CaliceMaps1TestSystemInterface * lSys[8];

    int lSysCount=CaliceMaps1TestSystemInterface::Instance(lSys, 8);

    int lMaster=0;
    for(int i=0; i<lSysCount; i++){
      if(lSys[i]->IsMaster()){
	lMaster=i;
	break;
      }
    }
    
    do{
      
      u32 lCoinCount=lSys[lMaster]->ReadPMTCoincidenceCount();

      cout<<"Coincidence Rate = "<<lCoinCount<<" Hz"<<endl;
      
    }while(gEnd==0);
    
    for(int i=0; i<lSysCount; i++){
      delete lSys[i];
    }

  }catch(USBDAQException & aExc){
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }


  return 0;
}
