#include <iostream>
#include <sstream>

#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include <signal.h>


int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  
  signal(SIGINT, CtrlC);

  try{
    
    
    LinuxLibUsbInterface lInt("", 
			      0xbd7, 
			      0x1003, 
			      0x0000);


    
    u32 lBlockSize=87;
    if(argc==2 || argc==3){
      istringstream(argv[1])>>lBlockSize;
    }

    u32 lNSamples=2;
    if(argc==3){
      istringstream(argv[2])>>lNSamples;
    }
      
    
    
    u32 * lBuf=new u32 [lBlockSize];

    u32 lCount=0;
    cout<<"block size = "<<lBlockSize<<" which is "<<(lBlockSize*sizeof(u32))<<" bytes"<<endl;
    for(u32 i=0; i<lNSamples; i++){
      if((i%1000)==0)
	cout<<i<<endl;

      lInt.ReadBlock(reinterpret_cast<u8*>(lBuf), lBlockSize*sizeof(u32));
      for(u32 j=0; j<lBlockSize; j++, lCount++){
	if(lCount!=lBuf[j])
	  cout<<lCount<<"   "<<lBuf[j]<<"   "<<(lCount==lBuf[j])<<endl;
      }
      if(gEnd){
	break;
      }
    }

    delete [] lBuf;

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
