#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //  signal(SIGUSR1, Usr1);

  try{
    

    CaliceMaps1TestSystemInterface lInt;

    lInt.EnableLVDSBuffers();
    
    lInt.SetupReferences();

    u16 lRef=0;
    if(argc==2){
      istringstream(argv[1])>>lRef;
    }

    u32 lCount=0;
   
    do{
      u16 lDin=static_cast<u16>(0xfff&lCount);
       lInt.SetReferenceLevel(lRef,lDin);

      u16 lDout=lInt.ReadReferenceLevel(lRef);
      
      if(lDout!=lDin){
	cout<<hex<<"Din = "<<lDin<<" Readback = "<<lDout<<endl;
	break;
      }
      //cout<<"Reference number  "<<lRef<<"  Level :  "<<(lCount&0xfff)<<std::endl;
	
      lCount++;
  
      if((lCount%100)==0){
	cout<<lCount<<endl;
      }
      
      if(gEnd==1){
	break;
      }

  }while(argc==2);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
