#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  try{
    

    CaliceMaps1TestSystemInterface lInt;

    lInt.EnableLVDSBuffers();
    
    u16 lDebugTrim=0;
    if(argc==2){
      istringstream(argv[1])>>lDebugTrim;
    }
    
    lInt.SetDebugTrim(lDebugTrim);

    lInt.SetReferenceLevel(22, 2048);
    


    do{


      for(u16 lLevel=1500; lLevel<2500; lLevel++){
	cout<<"DEbug Trim: "<<lDebugTrim<<"   VTH+ = "<<lLevel<<std::endl;
  	lInt.SetReferenceLevel(27, lLevel);
	if(gEnd==1){
	  break;
	}
      }      
       
      for(u16 lLevel=2500; lLevel>1500; lLevel--){
	cout<<"DEbug Trim: "<<lDebugTrim<<"   VTH+ = "<<lLevel<<std::endl;
  	lInt.SetReferenceLevel(27, lLevel);
	if(gEnd==1){
	  break;
	}

      } 
      
      lInt.SetDebugTrim(lDebugTrim);
      
      if(lDebugTrim==16){
	lDebugTrim=0;
      }
      
      if(gEnd==1){
	break;
      }
    }while(true);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
