
#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gInc=0;
void Usr1(int aSigNum){
  std::cout<<"User1 detected, ending program..."<<std::endl;
  gInc=1;
}
int gDec=0;
void Usr2(int aSigNum){
  std::cout<<"User1 detected, ending program..."<<std::endl;
  gDec=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  signal(SIGUSR1, Usr1); 
  signal(SIGUSR2, Usr2);

  try{
    

    CaliceMaps1TestSystemInterface lInt;

    //lInt.EnableLVDSBuffers();
    
    u16 lRef=0;
    if(argc==2){
      istringstream(argv[1])>>lRef;
    }
    
    int lPid=getpid();
    
    u32 lCount=0;
   
//     u16 lBuf0[32];
//     u16 lBuf1[32];
    do{
      
      
      lInt.SetReferenceLevel(lRef, lCount&0xfff);
      
      lCount++;
      cout<<SIGUSR1<<"++,  "<<SIGUSR2<<"--  : "
	  <<lPid<<" : reference number = "<<lRef<<endl;

      if(gEnd==1){
	break;
      }
      if(gInc==1){
	lRef++;
	if(lRef==32){
	  lRef=0;
	}
 	gInc=0;
      }
      if(gDec==1){
	if(lRef==0){
	  lRef=31;
	}else{
	  lRef--;
	}
 	gDec=0;
      }
      
    }while(true);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
