
#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gInc=0;
void Usr1(int aSigNum){
  std::cout<<"User1 detected, ending program..."<<std::endl;
  gInc=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  signal(SIGUSR1, Usr1);

  try{
    

    CaliceMaps1TestSystemInterface lInt;

    lInt.EnableLVDSBuffers();
    
    u16 lRef=0;
    if(argc==2){
      istringstream(argv[1])>>lRef;
    }
    
    int lPid=getpid();
    
    u32 lCount=0;
   
    u16 lBuf0[32];
    u16 lBuf1[32];
    do{
      
      for(u16 i=0; i<32; i++){
	lBuf0[i]=rand()&0xfff;
	lInt.SetReferenceLevel(i, lBuf0[i]);
      }
      
      for(u16 i=0; i<32; i++){
	lBuf1[i]=lInt.ReadReferenceLevel(i);
      }

      
      for(int i=0; i<32; i++){
	if(lBuf0[i]!=lBuf1[i]){
	  cout<<"********"<<endl;
	  cout<<hex<<lBuf0[i]<<" != "<<lBuf1[i]<<endl;
	}

      }

      lCount++;
      
      //if((lCount%100)==0)
      cout<<lCount<<endl;
  
      if(gEnd==1){
	break;
      }
     //  if(gInc==1){
// 	lRef++;
// 	gInc=0;
//       }
      
    }while(true);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
