#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  
  try{
    
    LinuxLibUsbInterface lInt("", 
			      0xbd7, 
			      0x1003, 
			      0x0000);
    
    lInt.SetAddressSpaceSize(31);
    
    // for the cable test we need to 
    // write to registers 1 and 2
    // and then read from them: 
    
    
        

    u32 lInput[20];
    u32 lOutput[20];
    
    for(u32 i=1; i<31; i++)
      {
	lInput[i]=i;
	lInt.Write(i, i);
	lInt.Read(i, lOutput[i]);
      }
    for(u32 i=1; i<31; i++)
      {
	cout<<i<<" : "<<lInput[i]<<" : "<<lOutput[i]<<endl;
      }

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
