#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  

  try{
    
    CaliceMaps1TestSystemInterface lInt0;
    CaliceMaps1TestSystemInterface lInt1;
//     cout<<"Firmware revision = "<<lInt.ReadFirmwareRevision()<<endl;
//     u32 lTime=lInt.ReadFirmwareRevisionUTC();
//     char lBuf[128];
//     cout<<"Built = "<<lTime<<endl;
    
    
//     cout<<"      = "<<ctime_r(reinterpret_cast<const time_t *>(&lTime), lBuf)<<endl;

    lInt0.LogicReset();
    lInt1.LogicReset();

    //    char crap=0;
    //cin>>crap;
    
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
