#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  try{
    

    CaliceMaps1TestSystemInterface lInt;

    lInt.EnableLVDSBuffers();
    
    u16 lRef=0;
    if(argc==2){
      istringstream(argv[1])>>lRef;
    }

    u32 lCount=0;

    u8 lBuf[24];
    for(u16 i=0; i<24; i++){
      lBuf[i]=0xff;
      cout<<"Loading byte "<<i<<" : "<<hex<<static_cast<u16>(lBuf[i])<<endl;
    }
    u8 lBuf2[24]={0};
    do{
      
      for(u16 i=0; i<24; i++){
	//lBuf[i]=0xff;//((lCount+i)&0xff);
	lBuf[i]=rand()&0xff;//((lCount+i)&0xff);
	//cout<<"Loading byte "<<i<<" : "<<hex<<static_cast<u16>(lBuf[i])<<endl;
      }


      lInt.LoadTopConfigRow(lBuf, lBuf2);
      
      
      if(gEnd==1){
	break;
      }
      
      if((++lCount)%1000==0){
	cout<<dec<<lCount<<endl;
      }
      

      for(u16 i=0; i<3; i++){
	lBuf2[i]=0xff&(~lBuf2[i]);
	if(lBuf2[i]!=lBuf[i]){
	  cout<<dec<<static_cast<u16>(lBuf2[i])<<" != "<<static_cast<u16>(lBuf[i]);
	  break;
	}
      }
      //      cout<<endl;
      
    }while(argc==2);
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
