#include <time.h>

#include <iostream>
#include <fstream>

#include "OptionHandler.hh"

#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>

#include <cstring>

#include "CaliceMaps1TestSystemInterface.hh"
#include "BunchTrainBuffer.hh"

void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}



int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

// int gQuit=0;
// void Usr1(int aSigNum){
//   std::cout<<"ctrl-c detected, ending program..."<<std::endl;
//   gQuit=1;
// }



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  OptionHandler lOpt(argc, argv);
  
  

  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  char * lModes[]={"default operation",
		   "leave init_b low after initialisation",
		   "inhibit readout",
		   "require readout trigger",
		   "inhibit in-spill sequencing",
		   "fill srams with 1ff",
		   "run slow clocks",
		   "invert rst_b polarity",
		   "invert fwd_b polarity",
		   "invert init_b polarity",
		   "Set hit override",
		   "run once"};
  int lNModes=sizeof(lModes)/sizeof(char *);
  
  int lTemp=0;

  bool lHelp=lOpt.GetOption('h');
  
  if(argc<2 || lHelp){//argc!=2 && argc!=3 && argc!=4 && argc!=5){
    cout<<"usage: "<<argv[0]<<" -m <spill mode (hex)> -n [<SpillCount>] -R[do readout] -C[<Spill Cycle Count>] -t[enable pmt trigger record]  -o [<stack pointer offset (dec)>] -s [<sense delay>] -r [<sram reset delay>] --start-offset [<start index offset>] -c [<readout col order (3,2,1,0) hex >] -L[do sensor load]  -g[<Global pixel mask>] -a [<Q1 mask>] -b[<Q2 mask>] -c[<Q3 mask>] -d[<Q4 mask>] -D[<Diode Reset Length>] -P[<Preamp Reset Length>] -S[<Shaper Reset Length>] -T[<time stamp fill value>]  -v [<verbosity level>] -V [sample count] -2 <clock phase 2>"<<endl;
    cout<<"Where spill mode bit field comprises: "<<endl;
    //cout<<lNModes<<" modes found."<<endl;
    for(int i=0; i<lNModes; i++){
      int lBit=i==0?0:1;
      cout<<hex<<"\t0x"<<(lBit<<(i-1))<<"\t=   "<<lModes[i]<<dec<<endl;
    }
    

    return 1;
  }
  
  u32 lVerbosity=0;
  if(!lOpt.GetOption('v', lTemp)){
    if(lTemp==0){
      lTemp++;
    }
    lVerbosity=lTemp;
  }

  u16 lMode=0;
  int lFullMode=0;
  if(!lOpt.GetOption('m', lFullMode, OptionHandler::HEX)){
    lMode=lFullMode&0x1f;
  }
  
  u16 lStackPtrOffset=0;
  if(!lOpt.GetOption('o', lTemp)){
    lMode|=0x20;
    lStackPtrOffset=static_cast<u16>(lTemp&0x1f);
  }

  if(lOpt.GetOption('t')){
    lMode|=0x40;
  }
  
  bool lSensorLoad=false;
  if(lOpt.GetOption('L')){
    lSensorLoad=true;
  }

  cout<<"sequencer spill mode = "<<hex<<lMode<<endl;

  u16 lSenseDelay=200;
  if(!lOpt.GetOption('s', lTemp)){
    lSenseDelay=lTemp&0xffff;
  }
  
  bool lRdEnOvrd=false;
  
  bool lLimitSpills=false;
  u32 lTotSpills=1;
 
  if(!lOpt.GetOption('n', lTemp)){
    lLimitSpills=true;
    lTotSpills=static_cast<u32>(lTemp);
  }

  bool lDoDAQ=lOpt.GetOption('R');
  if(lDoDAQ){
    cout<<"DAQ enabled"<<endl;
  }

  u16 lSramResetDelay=2;
  if(!lOpt.GetOption('r', lTemp)){
    lSramResetDelay=lTemp&0xffff;
  }

  u16 lROColOrder=0x1e;
  if(!lOpt.GetOption('c', lTemp, OptionHandler::HEX)){
    lROColOrder=lTemp&0xff;
  }
  
  u16 lStartIdx=0;
  if(!lOpt.GetOption("start-offset", lTemp)){
    lStartIdx=static_cast<u16>(lTemp);
    if(lStartIdx>3){
      cerr<<"error: start-offset > 3"<<endl;      
      return 1;
    }
  }

  
  int lSampleOutputCount=10;
  if(!lOpt.GetOption('V', lTemp)){
    lSampleOutputCount=lTemp;
  }

  if(lFullMode==0){
    cout<<"default operation"<<endl;
  }

  if(lFullMode & 0x2){
    cout<<"readout will not be performed."<<endl;
  }
  if(lFullMode & 0x4){
    cout<<"readout will await user trigger to commence"<<endl;
  }
  if(lFullMode & 0x8){
    cout<<"FSM will proceed directly to readout."<<endl;
  }
  
  bool lSlowClocks=false;
  if(lFullMode & 0x20){
    lSlowClocks=true;
    cout<<"Slow MC clock mode."<<endl;
  }else{
    cout<<"Fast MC clock mode."<<endl;
  }
  bool lRstBPol=false;
  if(lFullMode&0x40){
    lRstBPol=true;
    cout<<"invert rst_b polarity selected"<<endl;
  }

  bool lInitBPol=false;
  if(lFullMode&0x100){
    lInitBPol=true;
    cout<<"invert init_b polarity selected"<<endl;
  }
  
  bool lFwdBPol=false;
  if(lFullMode&0x80){
    lFwdBPol=true;
    cout<<"invert fwd_b polarity selected"<<endl;
  }
  if(lFullMode & 0x1){
    cout<<"init_b will be left low after spill initialisation "<<endl;
    if(lInitBPol){
      cout<<"** note that init_b inversion is selected."<<endl;
    }
  }  
  
  bool lHitOvrd=false;
  if(lFullMode & 0x200){
    cout<<"hit override set high "<<endl;
    lHitOvrd=true;
  }else{ 
    cout<<"hit override set low "<<endl;
  }
  bool lRunOnce=false;
  if(lFullMode & 0x400){
    cout<<"run once set. "<<endl;
    lRunOnce=true;
  }else{ 
    cout<<"repeated triggering. "<<endl;
  }
    
  cout<<dec<<"Sense Delay = "<<lSenseDelay<<" == "<<(10*lSenseDelay)<<"ns"<<endl;
  
  u16 lDiodeResetLength=4;
  if(!lOpt.GetOption('D', lTemp)){
    lDiodeResetLength=static_cast<u16>(lTemp);
  }

  u16 lShaperResetLength=20;
  if(!lOpt.GetOption('S', lTemp)){
    lShaperResetLength=static_cast<u16>(lTemp);
  }

  u16 lPreResetLength=10;
  if(!lOpt.GetOption('P', lTemp)){
    lPreResetLength=static_cast<u16>(lTemp);
  }
  
  u16 lStaticTs=0x1fff;
  if(!lOpt.GetOption('T', lTemp, OptionHandler::HEX)){
    lStaticTs=static_cast<u16>(lTemp&0x1fff);
  }

  u8 lGMask=0x10;
  if(!lOpt.GetOption('g', lTemp, OptionHandler::HEX)){
    lGMask=static_cast<u8>(lTemp&0x1f);
  }
  
  const u32 lNoBytes=168*5*24;
  u8 lMaskBuf[lNoBytes];
  u8 lReadBack[lNoBytes];
  u8 lDataOut[lNoBytes];
  memset(lMaskBuf, 0, lNoBytes);
  memset(lReadBack, 0, 1024);
  memset(lDataOut, 0, lNoBytes);
  
  //u8 lOne=0x1;
//   for(u32 lRow=0; lRow<168; lRow++){
//     for(u32 lBit=0; lBit<5; lBit++){
//       u8 lByte=((lOne<<lBit)&lGMask)==0?0:0xff;
//       for(u32 lCol=0; lCol<24; lCol++){
// 	lMaskBuf[(lRow*120)+(lBit*24)+lCol]=lByte;
//       }
//     }    
//   }

  for(u16 i=0; i<lNoBytes; i++){
    lMaskBuf[i]=0xaa;
  }  
  
  u16 lClock2=70;
  if(!lOpt.GetOption('2', lTemp)){
    lClock2=static_cast<u16>(lTemp);
  }

  u16 lPPRstLen=100;
  
  u32 lCycCount=2000;


  try{
    
    CaliceMaps1TestSystemInterface * lSys[4];
    
    int lCount=CaliceMaps1TestSystemInterface::Instance(lSys);
    
    u16 lSensorIdx[4];
    
    cout<<"============================================"<<endl;
    if(lCount==1){
      cout<<"there was "<<lCount<<" DAQ system detected"<<endl;
    }else{
      cout<<"there were "<<lCount<<" DAQ systems detected"<<endl;
    }
    cout<<"============================================"<<endl;
    
    if(lCount==0){
      return 0;
    }
    
    int lMaster=0;
    for(int i=0; i<lCount; i++){
      if(lSys[i]->IsMaster()){
	cout<<"number "<<i<<" is the master."<<endl;
	lMaster=i;
      }else{
	cout<<"number "<<i<<" is a slave."<<endl;
      }
    }
    for(int i=0; i<lCount; i++){
      lSensorIdx[i]=lSys[i]->ReadSensorId();
      cout<<"USBDAQ "<<i<<" is connected to sensor "<<lSensorIdx[i]<<endl; 
    }
    
    //CaliceMaps1TestSystemInterface lInt;
    
    
    //lInt.SetConfigReadoutMode();
    
    //cout<<"Enabling buffers: "<<endl;
    //lInt.EnableLVDSBuffers();

 //    for(int i=0;i<lCount;i++){
//       lSys[i]->SetClockPhase(2, lClock2);
//       //cout<<"**** clock phase 2 = "<<lSys[i]->ReadClockPhase(2)<<endl;
//     }

    Sleep(100);
    
    for(int i=0;i<lCount;i++){
      cout<<"Temperature = "<<lSys[i]->Temperature()<<endl;
    }
    
    for(int i=0;i<lCount;i++){
      lSys[i]->SetReadoutStartIndex(lStartIdx);
      cout<<"Start index = "<<lSys[i]->ReadReadoutStartIndex()<<endl;
    }

    for(int i=0;i<lCount;i++){
    
      lSys[i]->IssueTopConfigReset();
      lSys[i]->IssueSlowConfigReset();
      lSys[i]->IssueReadbackConfigReset();
    
      lSys[i]->SetTimeStampPrescale(0);

      lSys[i]->SetMonoPOR(false);
      lSys[i]->SetFastPhiOverride(false);

      lSys[i]->SetSenseDelay(lSenseDelay);
    
      lSys[i]->SetDiodeResetDuration(lDiodeResetLength);
      cout<<"Diode Reset Length = "<<lSys[i]->ReadDiodeResetDuration()<<endl;
      lSys[i]->SetPreAmpResetDuration(lPreResetLength);
      cout<<"Preamp Reset Length = "<<lSys[i]->ReadPreAmpResetDuration()<<endl;
      lSys[i]->SetShaperResetDuration(lShaperResetLength);
      cout<<"Shaper Reset Length = "<<lSys[i]->ReadShaperResetDuration()<<endl;    

      lSys[i]->SetMCResetDuration(10);
      cout<<"MC Reset duration = "<<dec<<lSys[i]->ReadMCResetDuration()<<endl;

      lSys[i]->SetSramFillClockSleep(lSramResetDelay);//100);
      if(lMode&0x10){
	cout<<"RAM fill inter-clock gap =  ~"<<(25*lSys[i]->ReadSramFillClockSleep())<<"ns"<<endl;
      
      }

      lSys[i]->SetPostPixResetSleepDuration(lPPRstLen);
      cout<<"Post Pixel Sleep Duration = "<<lSys[i]->ReadPostPixResetSleepDuration()<<endl;


      lSys[i]->SetDiscriminatorThresholds(140, 140);
      cout<<"Discriminator Thresholds = "<<lSys[i]->ReadDiscriminatorThreshold(0)<<", "
	  <<lSys[i]->ReadDiscriminatorThreshold(1)<<endl;
    
      lSys[i]->SetStackPointerOffset(lStackPtrOffset);
      cout<<"Stack pointer offset = "<<lSys[i]->ReadStackPointerOffset()<<endl;

      unsigned long lTestTrigStart=20000;
    
      lSys[i]->SetTestTrigStart(lTestTrigStart);
      lSys[i]->SetTestTrigStop(lTestTrigStart+100);
      lSys[i]->SetTestTrigConfig(8);
    
      cout<<dec<<"test trig start = "<<lSys[i]->ReadTestTrigStart()<<endl;
      cout<<"test trig stop = "<<lSys[i]->ReadTestTrigStop()<<endl;
      cout<<"test trig config = "<<lSys[i]->ReadTestTrigConfig()<<endl;
    
      

      lSys[i]->SetHitOverride(lHitOvrd);
      if(lSys[i]->ReadHitOverride()){
	cout<<"Hit override enabled"<<endl;
      }else{
	cout<<"Hit override disabled"<<endl;
      }
      lSys[i]->SetReadEnableOverride(lRdEnOvrd);

      if(lSys[i]->ReadReadEnableOverride()){
	cout<<"Read Enable broadcast enabled"<<endl;
      }else{
	cout<<"Standard Read Enable operation enabled"<<endl;
      }
    
      lSys[i]->SetInitBPolarity(lInitBPol);
      lSys[i]->SetRstBPolarity(lRstBPol);
      lSys[i]->SetFwdBPolarity(lFwdBPol);

      if(lSys[i]->ReadInitBPolarity()){
	cout<<"** init_b polarity inverted"<<endl;
      }

      if(lSys[i]->ReadFwdBPolarity()){
	cout<<"** fwd_b polarity inverted"<<endl;
      }
      if(lSys[i]->ReadRstBPolarity()){
	cout<<"** rst_b polarity inverted"<<endl;
      }
    
      lSys[i]->SetReadoutColumnOrder(lROColOrder);
      cout<<"Readout Column Order vector = "<<hex<<lSys[i]->ReadReadoutColumnOrder()<<dec<<endl;


      lSys[i]->SetStaticTimeStamp(lStaticTs);
      cout<<"Static time stamp = "<<hex<<lSys[i]->ReadStaticTimeStamp()<<dec<<endl;;
    
      lSys[i]->SetPixelEnable34(false);
      lSys[i]->SetPixelEnable12(false);
      
      if(!lOpt.GetOption('C', lTemp)){
	lCycCount=static_cast<u32>(lTemp);
      }
      lSys[i]->SetSpillCycleCount(lCycCount);
      cout<<"Spill Cycle Count = "<<lSys[i]->ReadSpillCycleCount()<<endl;
    
      lSys[i]->SetSpillCycleStart(6999);
      
      // setting the 9th bit to insert
      // the marker time stamps:
      lSys[i]->SetSpillMode(lMode|0x100);
      cout<<"Spill mode read back = "<<hex<<lSys[i]->ReadSpillMode()<<dec<<endl;
    
      lSys[i]->SetSlowSpillPhi(lSlowClocks);
    
      if(lSys[i]->ReadSlowSpillPhi()){
	cout<<"Slow MC Phi mode enabled"<<endl;
      }else{
	cout<<"Fast MC Phi mode enabled"<<endl;
      }
    
      cout<<"about to load...."<<endl;
      //lSys[i]->LoadConfig(lMaskBuf, lReadBack, 24, 168*5);
    
      lSys[i]->SetReferenceLevel(10, 3800);
      lSys[i]->SetReferenceLevel(20, 3500);
    
    }
    
    const u16 lNoRows=168*5;
    const u16 lNoBytes=lNoRows*24;


    u8 * lBufsIn[8];
    u8 * lTopBufs[8];
    u8 * lBufsOut[8];
    
    if(lSensorLoad){
      for(int i=0; i<lCount; i++){
	lBufsIn[i]=new u8 [lNoBytes];
	lTopBufs[i]=new u8 [168*3];
	for(u16 idx=0; idx<lNoBytes; idx++){
	  lBufsIn[i][idx]=rand();
	}
	
	cout<<"loading sensor configuration for sensor "<<i<<"..."<<flush;
	lSys[i]->LoadConfig(lBufsIn[i],lTopBufs[i],24,lNoRows);
	cout<<"done."<<endl;
      }
    }
    

    //u16 lStaticTimeStamp=~1;
    
    const u32 lBufLen=20000;
    //u32 lDataBuf[lBufLen];
    BunchTrainBuffer lDataBuf(lBufLen);    

    

    u8 lHistoryBuf[lBufLen];
    
    u32 lSpillCount=0;
    
//     lSys[i]->BufferReset();
//     cout<<"Start buffer input word count = "<<lInt.ReadBufferInputCount()<<endl;
//     cout<<"Start buffer output word count = "<<lInt.ReadBufferOutputCount()<<endl;
    
    //cout<<"Trigger History Word Count = "<<lInt.ReadTriggerHistoryWordCount()<<endl;
  
    //  ofstream lPMTTriggers("pmt_output.dat");
    
    

    //lSys[lMaster]->StartSpill();    
    
    for(int i=0; i<lCount; i++){
      lSys[i]->SetTriggerMask(0x1f);
      lSys[i]->SetTriggerSource(0);
      lSys[i]->SetTriggerEnable(true);
      
      cout<<"Trigger mask: "<<lSys[i]->ReadTriggerMask()<<endl;
      cout<<"Trigger source: "<<lSys[i]->ReadTriggerSource()<<endl;
      cout<<"Trigger enable: "<<lSys[i]->ReadTriggerEnable()<<endl;
    }
    
    //char crap=0;
    //cin>>crap;
    
    do{
      //lInt.SetStaticTimeStamp(lStaticTimeStamp);

      //
      //lInt.BufferReset();
      
      for(int j=0; j<lCount; j++){
	u16 lTemp=lSys[j]->ReadSensorId();
	if(lTemp!=lSensorIdx[j]){
	  cout<<"********** WARNING "<<j<<" is connected to sensor "<<lTemp<<endl; 
	  return 1;
	}
      }

      lSys[lMaster]->StartSpill();
      
      Sleep(5);
      //u32 lStat=lSys[lMaster].ReadStatus();
      //cout<<"Status = "<<hex<<lStat<<endl;
//       cout<<"Spill triggered. Retrigger? "<<endl;
      //  int crap=0;
      
 //      cin>>crap;
//       if(!crap){
// 	break;
//       }
      //Sleep(100);
      //      lStaticTimeStamp=lStaticTimeStamp<<1;
      //lStaticTimeStamp|=1;
      //if((lStaticTimeStamp&0x2000) == 0){
      //	lStaticTimeStamp=~1;
      // }
      
      //      cout<<"Static time stamp = "<<hex<<lStaticTimeStamp<<endl;
      //      for(u16 idx=0; idx<4; idx++)
      //	cout<<"Sensor column word count: "<<lInt.ReadSensorWordCount(idx)<<endl;
	
      for(int i=0; i<lCount; i++){
	if((lSpillCount%100)==0)
	  cout<<"board = "<<i<<", spill count = "<<lSpillCount<<endl;
	
	
	if(lMode&0x40){
	  
	  // 	  for(u32 j=0; j<10; j++){
	  // 	    cout<<j<<" "<<
	  // 	      lInt.ReadTriggerHistoryWordCount()<<endl;
	  // 	  }
	  
	  u32 lHistLen=lSys[i]->ReadTriggerHistory(lHistoryBuf, lBufLen);
	  //cout<<dec<<"history count = "<<lHistLen<<endl;
	  u32 lHitCount=0;
	  for(u32 j=0; j<lCycCount; j++){
	    if(i==lMaster){
	      unsigned short lPMTHit=lHistoryBuf[j]&0x3;
	      switch(lPMTHit){
	      case 0:
		lHitCount++;
		
		cout<<i<<" ***************** "<<dec<<j<<" of "
		    <<lHistLen<<" = "<<hex
		    <<static_cast<u16>(lHistoryBuf[j])<<endl;
		break;
	      case 1:
		cout<<i<<" ***************** "<<dec<<j<<" of "
		    <<lHistLen<<" = "<<hex
		    <<static_cast<u16>(lHistoryBuf[j])<<endl;	
		break;
	      case 2:
		cout<<i<<" ***************** "<<dec<<j<<" of "
		    <<lHistLen<<" = "<<hex
		    <<static_cast<u16>(lHistoryBuf[j])<<endl;
		break;
	      case 3:
		break;
		
	      }
	    }
	  }
	  
	  if(lHitCount>0){
	    //gEnd=1;
	    cout<<"******************* There were "<<dec<<lHitCount<<" PMT hits"<<endl;
	  }
	  //lPMTTriggers<<lHitCount<<'\n';
	}
	
	
	if(lDoDAQ){
	  if((lVerbosity)==2){
	    cout<<"Trigger number = "<<lSpillCount<<endl;
	    cout<<"predaq buffer input word count = "
		<<lSys[i]->ReadBufferInputCount()<<endl;
	    cout<<"predaq buffer output word count = "
		<<lSys[i]->ReadBufferOutputCount()<<endl;
	  }
	
	  u32 lTot=lSys[i]->DAQ(lDataBuf.GetBufferReference(), lBufLen);

	  if((lVerbosity)==3){
	    // 	  cout<<dec<<"Header:  "<<hex<<lDataBuf[0]<<endl;
	    // 	  cout<<dec<<"Header:  "<<hex<<lDataBuf[1]<<endl;
	    // 	  cout<<dec<<"Header:  "<<hex<<lDataBuf[2]<<endl;
	    //	  for(int idx=0; idx<lSampleOutputCount; idx++){
	    cout<<lDataBuf<<endl;
	    //}
	    cout<<"there were "<<dec<<lTot<<" words acquired"<<endl;
	    cout<<"postdaq buffer input word count = "
		<<lSys[i]->ReadBufferInputCount()<<endl;
	    cout<<"postdaq buffer output word count = "
		<<lSys[i]->ReadBufferOutputCount()<<endl;
	    cout<<"status = 0x"<<hex<<lSys[i]->ReadStatus()<<dec<<endl;
	  }
	
	}else{
	  
	  //cout<<"not resetting buffers"<<endl;
	  //  	lSys[i]->BufferReset();
	  //  	Sleep(10);
	  //  	lSys[i]->BufferReset();
	  //  	Sleep(10);
	  //  	lSys[i]->BufferReset();
	  //  	Sleep(10);
	  //  	lSys[i]->BufferReset();
	  //  	Sleep(10);
	  // 	}
	  
	}
      }
      // if(lTot>12768){
      // 	break;
      //       }
      
      
      
      if(lRunOnce)
	break;
      
      lSpillCount++;
      
      if(lSpillCount>=lTotSpills && lLimitSpills){
	break;
      }
      
    }while(gEnd==0);
    

    //    
    
//     for(int i=0; i<100; i++){
//       cout<<hex<<static_cast<u16>(lDataOut[i])<<endl;
//     }
    
    
    if(lSensorLoad){
      for(int k=0; k<lCount; k++){
	lBufsOut[k]=new u8 [lNoBytes];
	lSys[k]->ReadBackConfig(lBufsOut[k],21,840);      
      }
      

      for(int k=0; k<lCount; k++){
	u16 lInd0=0;
	u16 lInd1=0;
	u16 lInd2=0;
    
	u32 lErrCount0=0;
	u32 lErrCount1=0;

	for(u16 i=0; i<lNoRows; i++){
	  for(u16 j=0; j<24; j++, lInd0++){
	    //if(!i)
	    //cout<<lInd0<<"  "<<lInd1<<"  "<<lInd2<<endl;
	    if(j<3){
	      if(lBufsIn[k][lInd0]!=lTopBufs[k][lInd1]){
		lErrCount0++;
	      }
	      lInd1++;
	    }else{
	      u8 lMask=1;
	      for(u16 k=0; k<8;k++){
		//u16 lBin=8*j+k;
		if((lBufsIn[k][lInd0]&lMask)!=(lBufsOut[k][lInd2]&lMask)){
		  lErrCount1++;
		  //cout<<"column  = "<<dec<<lBin
		  //                  <<"  ERRORS : input = "
		  //                  <<hex<<static_cast<u16>(lBuf[lInd0])<<" output = "
		  //                  <<static_cast<u16>(lBufOut[lInd2])<<endl;
		}
		lMask=lMask<<1;
	      }
	      lInd2++;
	    }
	  

	  }
	
	}
	cout<<dec<<"sensor "<<k<<" error count = "<<lCount<<"  "<<lErrCount0<<" : "<<lErrCount1<<endl;
	
	
	for(int k=0; k<lCount; k++){
	  delete [] lTopBufs[k];
	  delete [] lBufsOut[k];
	  delete [] lBufsIn[k];
	}	
      }
    }
    


    for(int i=0; i<lCount; i++){
      delete lSys[i];
      lSys[i]=0;
    }
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
