#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}

void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  int lSel=0;

  if(argc==2){
    istringstream(argv[1])>>lSel;
  }
  
  u16 lTest=0;
  if(argc==3){
    istringstream(argv[1])>>lSel;
    istringstream(argv[2])>>lTest;
  }


  cout<<"examining sensor "<<lSel<<endl;

  try{
    
    CaliceMaps1TestSystemInterface * lSys[4];

    int lSysCount=CaliceMaps1TestSystemInterface::Instance(lSys);
    
    if(lSel>=lSysCount){
      cout<<"requested system doesn't exist"<<endl;
      return 1;
    }


    for(int i=0; i<lSysCount; i++)
      lSys[i]->EnableLVDSBuffers();
    
    //     
    
    
    


    //lInt.SetSlowConfigSRBitCount(840);
    //do{
    //lInt.TriggerSlowConfigShift();
      // Sleep(10);
      //}while(gEnd==0);

    //cout<<"sleeping..."<<endl;
    

    
    // }
    
 

  

    u32 lCount=0;

    const u16 lNoRows=168*5;
    const u16 lNoBytes=lNoRows*24;
    

    u8 * lBuf=new u8 [lNoBytes];
    memset(lBuf, 0, lNoBytes);
    
    u8 * lBuf2=new u8 [lNoBytes];
    memset(lBuf2, 0,lNoBytes);
    
    u8 * lBufOut=new u8 [21*lNoRows];
  
    
    u32 lHist[168<<3];
    
    memset(lHist, 0, (168<<4));
    
    srand(time(0));
    
    lSys[lSel]->IssueTopConfigReset();
    lSys[lSel]->IssueSlowConfigReset();
    lSys[lSel]->IssueReadbackConfigReset();
    
    cout<<"Test type selected: "<<endl;
    switch (lTest){
    case 0:
      cout<<"random."<<endl;
      break;
    case 1:
      cout<<"0xaa"<<endl;
      break;
    case 2:
      cout<<"0x00"<<endl;
      break;
    case 3: 
      cout<<"0xff"<<endl;
    default: 
      cout<<"random."<<endl;
      break;
    };
    do{
      
      
      for(u16 i=0; i<lNoBytes; i++){
	
	switch (lTest){
	case 0:
	  lBuf[i]=rand()&0xff;
	  break;
	case 1:
	  lBuf[i]=0xaa;;
	  break;
	case 2:
	  lBuf[i]=0x00;
	  break;
	case 3: 
	  lBuf[i]=0xff;
	  break;
	default: 
	  lBuf[i]=rand()&0xff;
	  break;
	};

      }

      //lSys[lSel]->IssueTopConfigReset();
      //lSys[lSel]->IssueSlowConfigReset();
      //lSys[lSel]->IssueReadbackConfigReset();
      
 
      lSys[lSel]->LoadConfig(lBuf, lBuf2,24,lNoRows);
      
      //cout<<"sleeping..."<<endl;
      //Sleep(1000);
      
      lSys[lSel]->ReadBackConfig(lBufOut,21,lNoRows);
      
      if(gEnd==1){
	break;
      }
      
      
//       for(u16 i=0; i<24; i++)
// 	cout<<static_cast<u16>(lBuf[i])<<"  ";
  
//       cout<<endl;

//       for(u16 i=0; i<3; i++)
// 	cout<<static_cast<u16>(lBuf2[i])<<"  ";
      
//       for(u16 i=0; i<21; i++)
// 	cout<<static_cast<u16>(lBufOut[i])<<"  ";
//       cout<<endl;

      u16 lInd0=0;
      u16 lInd1=0;
      u16 lInd2=0;
      
      u32 lErrCount0=0;
      u32 lErrCount1=0;

     
      for(u16 i=0; i<lNoRows; i++){
	for(u16 j=0; j<24; j++, lInd0++){

	  //if(!i)
	  //cout<<lInd0<<"  "<<lInd1<<"  "<<lInd2<<endl;
	  
	  if(j<3){

	    if(lBuf[lInd0]!=lBuf2[lInd1]){
	      lErrCount0++;
	    }
	    lInd1++;
	  }else{

	    u8 lMask=1;
	    
	    for(u16 k=0; k<8;k++){
	      u16 lBin=8*j+k;
	      if((lBuf[lInd0]&lMask)!=(lBufOut[lInd2]&lMask)){
		lErrCount1++;
		lHist[lBin]++;
		//cout<<"column  = "<<dec<<lBin
//  		    <<"  ERRORS : input = "
//  		    <<hex<<static_cast<u16>(lBuf[lInd0])<<" output = "
//  		    <<static_cast<u16>(lBufOut[lInd2])<<endl;
	      }
	      
	      lMask=lMask<<1;
	    }


	    lInd2++;
	  }

	}
      }
      lCount++; 
      cout<<dec<<lCount<<"  "<<lErrCount0<<" : "<<lErrCount1<<endl;
      
    }while(true);
  
    for(u16 i=24;i<192;i++){
      cout<<(i-24)<<"\t"<<lHist[i]<<'\n';
    }
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
