#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"
void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  try{
    
    u16 lClk=0;
    u16 lPhase=0x80;

    if(argc==3){
      istringstream(argv[1])>>lClk;
      istringstream(argv[2])>>lPhase;
      
    }else{
      cout<<"usage: "<<argv[0]<<" <clk no> <phase setting> "<<endl;
      //return 1;
    }
    
  
    CaliceMaps1TestSystemInterface lInt;

    lInt.EnableLVDSBuffers();
    
    if(argc==3){
      //do{
	//for(u16 i=0; i<256; i++){
	//cout<<i<<endl;
      lInt.SetClockPhase(lClk, lPhase);
      Sleep(500);
	//}
	// }while(gEnd==0);
    }
    
    cout<<"clk 0 phase = "<<lInt.ReadClockPhase(0)<<endl;
    cout<<"clk 1 phase = "<<lInt.ReadClockPhase(1)<<endl;
    cout<<"clk 1 phase = "<<lInt.ReadClockPhase(2)<<endl;


  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
