#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include "CaliceMaps1TestSystemInterface.hh"

#include <signal.h>


int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  
  

  try{
    CaliceMaps1TestSystemInterface * lSys[4];
    
    int lCount=CaliceMaps1TestSystemInterface::Instance(lSys);


    for(int i=0; i<lCount; i++)
      lSys[i]->SetupDiscriminatorReferenceDAC();

    //u16 lCount=0;
    //u16 lCountDown=255;
    if(argc==1){
    //   do{
		
// 	lInt.SetDiscriminatorThresholds(lCount, 
// 					lCountDown);
	
// 	cout<<"levels 0 and 1: "<<lCount<<" and "<<lCountDown<<" readback check = "
// 	    <<lInt.ReadDiscriminatorThreshold(0)<<", "
// 	    <<lInt.ReadDiscriminatorThreshold(1)<<endl; 
// 	if(lCount==255){
// 	  lCount=0;
// 	}else{
// 	  lCount++;
// 	}
	
// 	if(lCountDown==0){
// 	  lCountDown=255;
// 	}else{
// 	  lCountDown--;
// 	}
//       }while(gEnd==0);
    }
    
    if(argc==3){
      u16 lDac0=0;
      u16 lDac1=0;
      istringstream(argv[1])>>lDac0;
      istringstream(argv[2])>>lDac1;
      for(int i=0; i<lCount; i++){
	lSys[i]->SetDiscriminatorThresholds(lDac0,lDac1);
	cout<<"daq :"<<i<<" :"<<endl;
	cout<<"Discrimintator DAC codes set to "<<lSys[i]->ReadDiscriminatorThreshold(0)
	    <<" and "<<lSys[i]->ReadDiscriminatorThreshold(1)<<endl;
      }
      
    }


  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
