#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  try{
    
    
    u16 lEn=0;
    //    u16 lRefLevel=0;
    if(argc==2){
      istringstream(argv[1])>>lEn;
      //istringstream(argv[2])>>lRefLevel;
      
    }else{
      cout<<"usage: "<<argv[0]<<" <enable> "<<endl;
      //return 1;
    }
    
  
    CaliceMaps1TestSystemInterface lInt;

    lInt.EnableLVDSBuffers();
    
    lInt.SetFastPhiOverride(lEn);
    
    cout<<"Fast Phi override = "<<lInt.ReadFastPhiOverride()<<endl;

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
