#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>


#include "CaliceMaps1TestSystemInterface.hh"

int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

int gQuit=0;
void Usr1(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gQuit=1;
}



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  try{
    int lFSel=0;
    bool lEn=false;
    bool lLevel=false;

    if(argc==4){
      istringstream(argv[1])>>lFSel;
      istringstream(argv[2])>>lEn;
      istringstream(argv[3])>>lLevel;
      
    }else{
      cout<<"usage: "<<argv[0]<<" <function select> <en override> <level>"<<endl;
      cout<<"where function select = \n";
      cout<<"\t0 = read status\n\t1 = set slow shift reg reset override\n";
      cout<<"\t2 = set slow phi2 override\n\t3 = set slow phi3 override"
	  <<endl;
    }
    
    CaliceMaps1TestSystemInterface lInt;
    
    
    switch(lFSel){
    case 0:
      cout<<"------------------------"<<endl;
      cout<<"Read back only specified."<<endl;
      cout<<"------------------------"<<endl;
      break;
    case 1:
      cout<<"------------------------"<<endl;
      cout<<"Setting RST override:"<<endl;
      cout<<"------------------------"<<endl;
      lInt.SetSlowConfigRstOverride(lEn, lLevel);
      break;
    case 2:
      cout<<"------------------------"<<endl;
      cout<<"Setting Phi2 override:"<<endl;
      cout<<"------------------------"<<endl;
      lInt.SetSlowConfigPhi2Override(lEn, lLevel);
      break;
    case 3:
      cout<<"------------------------"<<endl;
      cout<<"Setting Phi3 override:"<<endl;
      cout<<"------------------------"<<endl;
      lInt.SetSlowConfigPhi3Override(lEn, lLevel);
      break;
    default:
      cout<<"------------------------"<<endl;
      cout<<"unrecognised option\n -> defaulting to readback."<<endl;
      cout<<"------------------------"<<endl;
      break;
    }    
    
    cout<<"Slow config option\tenable\tdc level\n";
    u16 lVal=lInt.ReadSlowConfigRstOverride();
    
    cout<<"Slow config reset:\t";
    if(lVal&2){
      cout<<"1\t";
    }else{
      cout<<"0\t";
    }
    if(lVal&0x1){
      cout<<"1\n";
    }else{
      cout<<"0\n";
    }

    cout<<"Slow config Phi2:\t";
    lVal=lInt.ReadSlowConfigPhi2Override();
    if(lVal&2){
      cout<<"1\t";
    }else{
      cout<<"0\t";
    }
    if(lVal&0x1){
      cout<<"1\n";
    }else{
      cout<<"0\n";
    }

    cout<<"Slow config phi3:\t";
    lVal=lInt.ReadSlowConfigPhi3Override();
    if(lVal&2){
      cout<<"1\t";
    }else{
      cout<<"0\t";
    }
    if(lVal&0x1){
      cout<<"1\n";
    }else{
      cout<<"0\n";
    }

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
