#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>

#include "CaliceMaps1TestSystemInterface.hh"

void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}



int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

// int gQuit=0;
// void Usr1(int aSigNum){
//   std::cout<<"ctrl-c detected, ending program..."<<std::endl;
//   gQuit=1;
// }



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  char * lModes[]={"default operation",
		   "leave init_b low after initialisation",
		   "inhibit readout",
		   "require readout trigger",
		   "inhibit in-spill sequencing",
		   "fill srams with 1ff",
		   "run slow clocks",
		   "invert rst_b polarity",
		   "invert fwd_b polarity",
		   "invert init_b polarity",
		   "Set hit override",
		   "run once"};
  int lNModes=sizeof(lModes)/sizeof(char *);

  if(argc!=2 && argc!=3 && argc!=4 && argc!=5){
    cout<<"usage: "<<argv[0]<<" <spill mode (hex)> [<sense delay>] [<sram reset delay>] [<readout col order (3,2,1,0) hex >] "<<endl;
    cout<<"Where spill mode bit field comprises: "<<endl;
    //cout<<lNModes<<" modes found."<<endl;
    for(int i=0; i<lNModes; i++){
      int lBit=i==0?0:1;
      cout<<hex<<"\t0x"<<(lBit<<(i-1))<<"\t=   "<<lModes[i]<<dec<<endl;
    }
    

    return 1;
  }
  
  
  u16 lMode=0;
  if(argc>1){
    istringstream(argv[1])>>hex>>lMode;
    cout<<"spill mode = "<<hex<<lMode<<endl;
  }

  u16 lSenseDelay=30;
  if(argc==3){
    istringstream(argv[2])>>lSenseDelay;
  }

  bool lRdEnOvrd=false;
  u16 lSramResetDelay=100;
  if(argc==4){
    istringstream(argv[2])>>lSenseDelay;
    istringstream(argv[3])>>lSramResetDelay;
  }
  u16 lROColOrder=0x1e;
  if(argc==5){
    istringstream(argv[2])>>lSenseDelay;
    istringstream(argv[3])>>lSramResetDelay;
    istringstream(argv[4])>>hex>>lROColOrder;
  }
  

  

  if(lMode==0){
    cout<<"default operation"<<endl;
  }

  if(lMode & 0x2){
    cout<<"readout will not be performed."<<endl;
  }
  if(lMode & 0x4){
    cout<<"readout will await user trigger to commence"<<endl;
  }
  if(lMode & 0x8){
    cout<<"FSM will proceed directly to readout."<<endl;
  }
  
  bool lSlowClocks=false;
  if(lMode & 0x20){
    lSlowClocks=true;
    cout<<"Slow MC clock mode."<<endl;
  }else{
    cout<<"Fast MC clock mode."<<endl;
  }
  bool lRstBPol=false;
  if(lMode&0x40){
    lRstBPol=true;
    cout<<"invert rst_b polarity selected"<<endl;
  }

  bool lInitBPol=false;
  if(lMode&0x100){
    lInitBPol=true;
    cout<<"invert init_b polarity selected"<<endl;
  }
  
  bool lFwdBPol=false;
  if(lMode&0x80){
    lFwdBPol=true;
    cout<<"invert fwd_b polarity selected"<<endl;
  }
  if(lMode & 0x1){
    cout<<"init_b will be left low after spill initialisation "<<endl;
    if(lInitBPol){
      cout<<"** note that init_b inversion is selected."<<endl;
    }
  }  
  
  bool lHitOvrd=false;
  if(lMode & 0x200){
    cout<<"hit override set high "<<endl;
    lHitOvrd=true;
  }else{ 
    cout<<"hit override set low "<<endl;
  }
  bool lRunOnce=false;
  if(lMode & 0x400){
    cout<<"run once set. "<<endl;
    lRunOnce=true;
  }else{ 
    cout<<"repeated triggering. "<<endl;
  }
  
  

  lMode&=0x1f;

  cout<<dec<<"Sense Delay = "<<lSenseDelay<<" == "<<(10*lSenseDelay)<<"ns"<<endl;

  try{
    

    CaliceMaps1TestSystemInterface lInt;
    
    cout<<"Enabling buffers: "<<endl;
    lInt.EnableLVDSBuffers();

    //lInt.SetReferenceLevel(10, 3800);
    //lInt.SetReferenceLevel(20, 3500);
    
    cout<<"Reference set: "<<lInt.ReadReferenceLevel(10)<<endl;
    cout<<"Reference set: "<<lInt.ReadReferenceLevel(20)<<endl;

    cout<<"Temperature = "<<lInt.Temperature()<<endl;

    lInt.IssueTopConfigReset();
    lInt.IssueSlowConfigReset();
    lInt.IssueReadbackConfigReset();
    
    lInt.SetTimeStampPrescale(0);

    lInt.SetMonoPOR(true);
    lInt.SetFastPhiOverride(false);

    lInt.SetSenseDelay(lSenseDelay);

    lInt.SetDiodeResetDuration(20);
    lInt.SetPreAmpResetDuration(30);
    lInt.SetShaperResetDuration(40);

    lInt.SetMCResetDuration(10);
    cout<<"MC Reset duration = "<<dec<<lInt.ReadMCResetDuration()<<endl;

    lInt.SetSramFillClockSleep(lSramResetDelay);//100);
    if(lMode&0x10){
      cout<<"RAM fill inter-clock gap =  ~"<<(25*lInt.ReadSramFillClockSleep())<<"ns"<<endl;
      
    }
    lInt.SetHitOverride(lHitOvrd);
    if(lInt.ReadHitOverride()){
      cout<<"Hit iverride enabled"<<endl;
    }else{
      cout<<"Hit override disabled"<<endl;
    }
    lInt.SetReadEnableOverride(lRdEnOvrd);

    if(lInt.ReadReadEnableOverride()){
      cout<<"Read Enable broadcast enabled"<<endl;
    }else{
      cout<<"Standard Read Enable operation enabled"<<endl;
    }
    
    lInt.SetInitBPolarity(lInitBPol);
    lInt.SetRstBPolarity(lRstBPol);
    lInt.SetFwdBPolarity(lFwdBPol);

    if(lInt.ReadInitBPolarity()){
      cout<<"** init_b polarity inverted"<<endl;
    }

    if(lInt.ReadFwdBPolarity()){
      cout<<"** fwd_b polarity inverted"<<endl;
    }
    if(lInt.ReadRstBPolarity()){
      cout<<"** rst_b polarity inverted"<<endl;
    }
    
    lInt.SetReadoutColumnOrder(lROColOrder);
    cout<<"Readout Column Order vector = "<<hex<<lInt.ReadReadoutColumnOrder()<<dec<<endl;


    lInt.SetStaticTimeStamp(0x1fff);

    cout<<"Static time stamp = "<<hex<<lInt.ReadStaticTimeStamp()<<dec<<endl;;

    //    lInt.SetPixelEnable34(false);
    //    lInt.SetPixelEnable12(false);
    
    lInt.SetSpillCycleCount(255);
    cout<<"Spill Cycle Count = "<<lInt.ReadSpillCycleCount()<<endl;
    
    lInt.SetSpillMode(lMode);
    cout<<"Spill mode read back = "<<hex<<lInt.ReadSpillMode()<<dec<<endl;
    
    lInt.SetSlowSpillPhi(lSlowClocks);
    
    if(lInt.ReadSlowSpillPhi()){
      cout<<"Slow MC Phi mode enabled"<<endl;
    }else{
      cout<<"Fast MC Phi mode enabled"<<endl;
    }

    //u16 lStaticTimeStamp=~1;
    
    u32 lDataBuf[100000];
    
    do{
      //lInt.SetStaticTimeStamp(lStaticTimeStamp);

      lInt.StartSpill();
      //u32 lStat=lInt.ReadStatus();
    //   cout<<"Status = "<<hex<<lStat<<endl;
//       cout<<"Spill triggered. Retrigger? "<<endl;
      //  int crap=0;
      
 //      cin>>crap;
//       if(!crap){
// 	break;
//       }
      Sleep(100);
      //      lStaticTimeStamp=lStaticTimeStamp<<1;
      //lStaticTimeStamp|=1;
      //if((lStaticTimeStamp&0x2000) == 0){
      //	lStaticTimeStamp=~1;
      // }

      //      cout<<"Static time stamp = "<<hex<<lStaticTimeStamp<<endl;
      //      for(u16 idx=0; idx<4; idx++)
// 	cout<<"Sensor column word count: "<<hex<<lInt.ReadSensorWordCount(idx)<<endl;
	
	u32 lTot=lInt.DAQ(lDataBuf, 100000);
	cout<<"there were "<<dec<<lTot<<" words acquired"<<endl;
//       for(u32 idx=0; idx<lTot; lTot++){
//       	cout<<hex<<lDataBuf[idx]<<endl;
//       }
      
      
      if(lRunOnce)
	break;
      
    }while(gEnd==0);
    
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
