#include <time.h>
#include <signal.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"

#include "CaliceMaps1TestSystemInterface.hh"

void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}
int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}




int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
   
  signal(SIGINT, CtrlC);

  try{
    

    CaliceMaps1TestSystemInterface lInt;

    lInt.EnableLVDSBuffers();

    u32 lCount=0;
    do{
      
      
      double lTemp=lInt.Temperature();
      
      
      cout<<lCount++<<" temp = "<<lTemp<<endl;
      
      //      Sleep(100);

      if(gEnd==1){
	break;
      }
      
    }while(argc==2);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
