#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"


int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  
  try{
    
    LinuxLibUsbInterface lInt("", 
			      0xbd7, 
			      0x1003, 
			      0x0000);

    
    u32 lCount=0;
    do{
      
      u32 lTemp=rand();
      lInt.Write(1, lTemp);
      u32 lData=0;
      lInt.Read(3,lData);
      if(lTemp!=lData){
	cout<<"!!! "<<hex<<lData<<" != "<<lTemp<<endl;
	return 1;
      }
      lCount++;
      if((lCount%1000)==0)
	cout<<lCount<<endl;
      
    }while(1);

  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
