#include <time.h>

#include <iostream>
#include "USBDAQException.hh"
#include "LinuxLibUsbInterface.hh"
#include <signal.h>

#include "CaliceMaps1TestSystemInterface.hh"

void Sleep(unsigned long ams)
{
  struct timespec lReq;
  struct timespec lRem;
  lReq.tv_sec=ams/1000;
  lReq.tv_nsec=(ams%1000)*1000000;
  nanosleep(&lReq, &lRem);
}



int gEnd=0;

void CtrlC(int aSigNum){
  std::cout<<"ctrl-c detected, ending program..."<<std::endl;
  gEnd=1;
}

// int gQuit=0;
// void Usr1(int aSigNum){
//   std::cout<<"ctrl-c detected, ending program..."<<std::endl;
//   gQuit=1;
// }



int main(int argc, char ** argv)
{
  using namespace std;
  using namespace USBDAQ;
  using namespace CALICEMAPS1;
  
  signal(SIGINT, CtrlC);
  //signal(SIGUSR1, Usr1);

  try{
    

    CaliceMaps1TestSystemInterface lInt;
    
    cout<<"Enabling buffers: "<<endl;
    lInt.EnableLVDSBuffers();
    
    cout<<"Temperature = "<<lInt.Temperature()<<endl;

    lInt.IssueTopConfigReset();
    lInt.IssueSlowConfigReset();
    lInt.IssueReadbackConfigReset();
    
    lInt.SetTimeStampPrescale(15);

    lInt.SetMonoPOR(true);
    lInt.SetFastPhiOverride(false);

    lInt.SetSenseDelay(30);

    lInt.SetDiodeResetDuration(20);
    lInt.SetPreAmpResetDuration(30);
    lInt.SetShaperResetDuration(40);
      
    lInt.SetHitOverride(true);
    
    lInt.SetPixelEnable34(false);
    lInt.SetPixelEnable12(false);
    
    lInt.SetSpillCycleCount(5);
    cout<<"Spill Cycle Count = "<<lInt.ReadSpillCycleCount()<<endl;

    do{
      lInt.StartSpill();
      u32 lStat=lInt.ReadStatus();
      cout<<"Status = "<<hex<<lStat<<endl;
      cout<<"Spill triggered. Retrigger? "<<endl;
      //  int crap=0;
      
 //      cin>>crap;
//       if(!crap){
// 	break;
//       }
      
    }while(gEnd==0);
    
    
  }catch(USBDAQException & aExc){    
    cerr<<aExc<<endl;
    return 1;
  }catch(std::exception & aExc){
    cerr<<"std::exception & caught: "<<endl;
    cerr<<aExc.what();
    return 2;
  }catch(...){
    cerr<<"Unknown exception caught."<<endl;
    return 3;
  }

  return 0;
}
